/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.logic;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.config.SaOAuth2Config;
import cn.dev33.satoken.oauth2.exception.SaOAuth2Exception;
import cn.dev33.satoken.oauth2.logic.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.logic.SaOAuth2Util;
import cn.dev33.satoken.oauth2.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.model.CodeModel;
import cn.dev33.satoken.oauth2.model.RequestAuthModel;
import cn.dev33.satoken.oauth2.model.SaClientModel;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.util.SaResult;
import java.util.Map;

public class SaOAuth2Handle {
    public static Object serverRequest() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaOAuth2Config cfg = SaOAuth2Manager.getConfig();
        if (req.isPath(SaOAuth2Consts.Api.authorize) && req.isParam(SaOAuth2Consts.Param.response_type, SaOAuth2Consts.ResponseType.code)) {
            SaClientModel cm = SaOAuth2Handle.currClientModel();
            if (cfg.isCode.booleanValue() && (cm.isCode.booleanValue() || cm.isAutoMode.booleanValue())) {
                return SaOAuth2Handle.authorize(req, res, cfg);
            }
            throw new SaOAuth2Exception("\u6682\u672a\u5f00\u653e\u7684\u6388\u6743\u6a21\u5f0f");
        }
        if (req.isPath(SaOAuth2Consts.Api.token) && req.isParam(SaOAuth2Consts.Param.grant_type, SaOAuth2Consts.GrantType.authorization_code)) {
            return SaOAuth2Handle.token(req, res, cfg);
        }
        if (req.isPath(SaOAuth2Consts.Api.refresh) && req.isParam(SaOAuth2Consts.Param.grant_type, SaOAuth2Consts.GrantType.refresh_token)) {
            return SaOAuth2Handle.refreshToken(req);
        }
        if (req.isPath(SaOAuth2Consts.Api.revoke)) {
            return SaOAuth2Handle.revokeToken(req);
        }
        if (req.isPath(SaOAuth2Consts.Api.doLogin)) {
            return SaOAuth2Handle.doLogin(req, res, cfg);
        }
        if (req.isPath(SaOAuth2Consts.Api.doConfirm)) {
            return SaOAuth2Handle.doConfirm(req);
        }
        if (req.isPath(SaOAuth2Consts.Api.authorize) && req.isParam(SaOAuth2Consts.Param.response_type, SaOAuth2Consts.ResponseType.token)) {
            SaClientModel cm = SaOAuth2Handle.currClientModel();
            if (cfg.isImplicit.booleanValue() && (cm.isImplicit.booleanValue() || cm.isAutoMode.booleanValue())) {
                return SaOAuth2Handle.authorize(req, res, cfg);
            }
            throw new SaOAuth2Exception("\u6682\u672a\u5f00\u653e\u7684\u6388\u6743\u6a21\u5f0f");
        }
        if (req.isPath(SaOAuth2Consts.Api.token) && req.isParam(SaOAuth2Consts.Param.grant_type, SaOAuth2Consts.GrantType.password)) {
            SaClientModel cm = SaOAuth2Handle.currClientModel();
            if (cfg.isPassword.booleanValue() && (cm.isPassword.booleanValue() || cm.isAutoMode.booleanValue())) {
                return SaOAuth2Handle.password(req, res, cfg);
            }
            throw new SaOAuth2Exception("\u6682\u672a\u5f00\u653e\u7684\u6388\u6743\u6a21\u5f0f");
        }
        if (req.isPath(SaOAuth2Consts.Api.client_token) && req.isParam(SaOAuth2Consts.Param.grant_type, SaOAuth2Consts.GrantType.client_credentials)) {
            SaClientModel cm = SaOAuth2Handle.currClientModel();
            if (cfg.isClient.booleanValue() && (cm.isClient.booleanValue() || cm.isAutoMode.booleanValue())) {
                return SaOAuth2Handle.clientToken(req, res, cfg);
            }
            throw new SaOAuth2Exception("\u6682\u672a\u5f00\u653e\u7684\u6388\u6743\u6a21\u5f0f");
        }
        return "{\"msg\": \"not handle\"}";
    }

    public static Object authorize(SaRequest req, SaResponse res, SaOAuth2Config cfg) {
        if (!StpUtil.isLogin()) {
            return cfg.notLoginView.get();
        }
        RequestAuthModel ra = SaOAuth2Util.generateRequestAuth(req, StpUtil.getLoginId());
        SaOAuth2Util.checkRightUrl(ra.clientId, ra.redirectUri);
        SaOAuth2Util.checkContract(ra.clientId, ra.scope);
        boolean isGrant = SaOAuth2Util.isGrant(ra.loginId, ra.clientId, ra.scope);
        if (!isGrant) {
            return cfg.confirmView.apply(ra.clientId, ra.scope);
        }
        if (SaOAuth2Consts.ResponseType.code.equals(ra.responseType)) {
            CodeModel codeModel = SaOAuth2Util.generateCode(ra);
            String redirectUri = SaOAuth2Util.buildRedirectUri(ra.redirectUri, codeModel.code, ra.state);
            return res.redirect(redirectUri);
        }
        if (SaOAuth2Consts.ResponseType.token.equals(ra.responseType)) {
            AccessTokenModel at = SaOAuth2Util.generateAccessToken(ra, false);
            String redirectUri = SaOAuth2Util.buildImplicitRedirectUri(ra.redirectUri, at.accessToken, ra.state);
            return res.redirect(redirectUri);
        }
        throw new SaOAuth2Exception("\u65e0\u6548response_type: " + ra.responseType);
    }

    public static Object token(SaRequest req, SaResponse res, SaOAuth2Config cfg) {
        String code = req.getParamNotNull(SaOAuth2Consts.Param.code);
        String clientId = req.getParamNotNull(SaOAuth2Consts.Param.client_id);
        String clientSecret = req.getParamNotNull(SaOAuth2Consts.Param.client_secret);
        String redirectUri = req.getParam(SaOAuth2Consts.Param.redirect_uri);
        SaOAuth2Util.checkGainTokenParam(code, clientId, clientSecret, redirectUri);
        AccessTokenModel token = SaOAuth2Util.generateAccessToken(code);
        return SaResult.data(token.toLineMap());
    }

    public static Object refreshToken(SaRequest req) {
        String clientId = req.getParamNotNull(SaOAuth2Consts.Param.client_id);
        String clientSecret = req.getParamNotNull(SaOAuth2Consts.Param.client_secret);
        String refreshToken = req.getParamNotNull(SaOAuth2Consts.Param.refresh_token);
        SaOAuth2Util.checkRefreshTokenParam(clientId, clientSecret, refreshToken);
        Map<String, Object> data = SaOAuth2Util.refreshAccessToken(refreshToken).toLineMap();
        return SaResult.data(data);
    }

    public static Object revokeToken(SaRequest req) {
        String clientId = req.getParamNotNull(SaOAuth2Consts.Param.client_id);
        String clientSecret = req.getParamNotNull(SaOAuth2Consts.Param.client_secret);
        String accessToken = req.getParamNotNull(SaOAuth2Consts.Param.access_token);
        if (SaOAuth2Util.getAccessToken(accessToken) == null) {
            return SaResult.ok((String)("access_token\u4e0d\u5b58\u5728\uff1a" + accessToken));
        }
        SaOAuth2Util.checkAccessTokenParam(clientId, clientSecret, accessToken);
        SaOAuth2Util.revokeAccessToken(accessToken);
        return SaResult.ok();
    }

    public static Object doLogin(SaRequest req, SaResponse res, SaOAuth2Config cfg) {
        return cfg.doLoginHandle.apply(req.getParamNotNull(SaOAuth2Consts.Param.name), req.getParamNotNull("pwd"));
    }

    public static Object doConfirm(SaRequest req) {
        String clientId = req.getParamNotNull(SaOAuth2Consts.Param.client_id);
        String scope = req.getParamNotNull(SaOAuth2Consts.Param.scope);
        Object loginId = StpUtil.getLoginId();
        SaOAuth2Util.saveGrantScope(clientId, loginId, scope);
        return SaResult.ok();
    }

    public static Object password(SaRequest req, SaResponse res, SaOAuth2Config cfg) {
        String username = req.getParamNotNull(SaOAuth2Consts.Param.username);
        String password = req.getParamNotNull(SaOAuth2Consts.Param.password);
        String clientId = req.getParamNotNull(SaOAuth2Consts.Param.client_id);
        String scope = req.getParam(SaOAuth2Consts.Param.scope, "");
        SaOAuth2Util.checkContract(clientId, scope);
        SaHolder.getStorage().set(StpUtil.stpLogic.splicingKeyJustCreatedSave(), (Object)"no-token");
        Object retObj = cfg.doLoginHandle.apply(username, password);
        if (!StpUtil.isLogin()) {
            return retObj;
        }
        RequestAuthModel ra = new RequestAuthModel();
        ra.clientId = clientId;
        ra.loginId = StpUtil.getLoginId();
        ra.scope = scope;
        AccessTokenModel at = SaOAuth2Util.generateAccessToken(ra, true);
        return SaResult.data(at.toLineMap());
    }

    public static Object clientToken(SaRequest req, SaResponse res, SaOAuth2Config cfg) {
        String clientId = req.getParamNotNull(SaOAuth2Consts.Param.client_id);
        String clientSecret = req.getParamNotNull(SaOAuth2Consts.Param.client_secret);
        String scope = req.getParam(SaOAuth2Consts.Param.scope);
        SaOAuth2Util.checkContract(clientId, scope);
        SaOAuth2Util.checkClientSecret(clientId, clientSecret);
        ClientTokenModel ct = SaOAuth2Util.generateClientToken(clientId, scope);
        return SaResult.data(ct.toLineMap());
    }

    public static SaClientModel currClientModel() {
        String clientId = SaHolder.getRequest().getParam(SaOAuth2Consts.Param.client_id);
        return SaOAuth2Util.checkClientModel(clientId);
    }
}

