/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.reactor.filter;

import cn.dev33.satoken.exception.BackResultException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.filter.SaFilterAuthStrategy;
import cn.dev33.satoken.filter.SaFilterErrorStrategy;
import cn.dev33.satoken.reactor.context.SaReactorHolder;
import cn.dev33.satoken.reactor.context.SaReactorSyncHolder;
import cn.dev33.satoken.router.SaRouter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-100)
public class SaReactorFilter
implements WebFilter {
    private List<String> includeList = new ArrayList<String>();
    private List<String> excludeList = new ArrayList<String>();
    public SaFilterAuthStrategy auth = r -> {};
    public SaFilterErrorStrategy error = e -> {
        throw new SaTokenException(e);
    };
    public SaFilterAuthStrategy beforeAuth = r -> {};

    public SaReactorFilter addInclude(String ... paths) {
        this.includeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaReactorFilter addExclude(String ... paths) {
        this.excludeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaReactorFilter setIncludeList(List<String> pathList) {
        this.includeList = pathList;
        return this;
    }

    public SaReactorFilter setExcludeList(List<String> pathList) {
        this.excludeList = pathList;
        return this;
    }

    public List<String> getIncludeList() {
        return this.includeList;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    public SaReactorFilter setAuth(SaFilterAuthStrategy auth) {
        this.auth = auth;
        return this;
    }

    public SaReactorFilter setError(SaFilterErrorStrategy error) {
        this.error = error;
        return this;
    }

    public SaReactorFilter setBeforeAuth(SaFilterAuthStrategy beforeAuth) {
        this.beforeAuth = beforeAuth;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        exchange.getAttributes().put("WEB_FILTER_CHAIN_KEY", chain);
        try {
            SaReactorSyncHolder.setContext(exchange);
            SaRouter.match(this.includeList).notMatch(this.excludeList).check(r -> {
                this.beforeAuth.run(null);
                this.auth.run(null);
            });
        }
        catch (StopMatchException stopMatchException) {
        }
        catch (Throwable e) {
            String result;
            String string = result = e instanceof BackResultException ? e.getMessage() : String.valueOf(this.error.run(e));
            if (exchange.getResponse().getHeaders().getFirst("Content-Type") == null) {
                exchange.getResponse().getHeaders().set("Content-Type", "text/plain; charset=utf-8");
            }
            Mono mono = exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(result.getBytes())));
            return mono;
        }
        finally {
            SaReactorSyncHolder.clearContext();
        }
        SaReactorSyncHolder.setContext(exchange);
        return chain.filter(exchange).subscriberContext(ctx -> {
            ctx = ctx.put(SaReactorHolder.CONTEXT_KEY, (Object)exchange);
            return ctx;
        }).doFinally(r -> SaReactorSyncHolder.clearContext());
    }
}

