/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.reactor.model;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.reactor.context.SaReactorSyncHolder;
import cn.dev33.satoken.util.SaFoxUtil;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;

public class SaRequestForReactor
implements SaRequest {
    protected ServerHttpRequest request;

    public SaRequestForReactor(ServerHttpRequest request) {
        this.request = request;
    }

    public Object getSource() {
        return this.request;
    }

    public String getParam(String name) {
        return (String)this.request.getQueryParams().getFirst((Object)name);
    }

    public String getHeader(String name) {
        return this.request.getHeaders().getFirst(name);
    }

    public String getCookieValue(String name) {
        HttpCookie cookie = (HttpCookie)this.request.getCookies().getFirst((Object)name);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public String getRequestPath() {
        return this.request.getURI().getPath();
    }

    public String getUrl() {
        String currDomain = SaManager.getConfig().getCurrDomain();
        if (!SaFoxUtil.isEmpty((Object)currDomain)) {
            return currDomain + this.getRequestPath();
        }
        return this.request.getURI().toString();
    }

    public String getMethod() {
        return this.request.getMethodValue();
    }

    public Object forward(String path) {
        ServerWebExchange exchange = SaReactorSyncHolder.getContext();
        WebFilterChain chain = (WebFilterChain)exchange.getAttribute("WEB_FILTER_CHAIN_KEY");
        ServerHttpRequest newRequest = this.request.mutate().path(path).build();
        ServerWebExchange newExchange = exchange.mutate().request(newRequest).build();
        return chain.filter(newExchange);
    }
}

