/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.reactor.model;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.application.ApplicationInfo;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.reactor.context.SaReactorSyncHolder;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;

public class SaRequestForReactor
implements SaRequest {
    protected ServerHttpRequest request;

    public SaRequestForReactor(ServerHttpRequest request) {
        this.request = request;
    }

    public Object getSource() {
        return this.request;
    }

    public String getParam(String name) {
        return (String)this.request.getQueryParams().getFirst((Object)name);
    }

    public List<String> getParamNames() {
        Set names = this.request.getQueryParams().keySet();
        return new ArrayList<String>(names);
    }

    public Map<String, String> getParamMap() {
        return this.request.getQueryParams().toSingleValueMap();
    }

    public String getHeader(String name) {
        return this.request.getHeaders().getFirst(name);
    }

    public String getCookieValue(String name) {
        return this.getCookieLastValue(name);
    }

    public String getCookieFirstValue(String name) {
        HttpCookie cookie = (HttpCookie)this.request.getCookies().getFirst((Object)name);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public String getCookieLastValue(String name) {
        String value = null;
        String cookieStr = this.getHeader("Cookie");
        if (SaFoxUtil.isNotEmpty((Object)cookieStr)) {
            String[] cookieItems;
            for (String item : cookieItems = cookieStr.split(";")) {
                String[] kv = item.split("=");
                if (kv.length != 2 || !kv[0].trim().equals(name)) continue;
                value = kv[1].trim();
            }
        }
        return value;
    }

    public String getRequestPath() {
        return ApplicationInfo.cutPathPrefix((String)this.request.getPath().toString());
    }

    public String getUrl() {
        String currDomain = SaManager.getConfig().getCurrDomain();
        if (!SaFoxUtil.isEmpty((Object)currDomain)) {
            return currDomain + this.getRequestPath();
        }
        return this.request.getURI().toString();
    }

    public String getMethod() {
        return this.request.getMethod().name();
    }

    public Object forward(String path) {
        ServerWebExchange exchange = SaReactorSyncHolder.getContext();
        WebFilterChain chain = (WebFilterChain)exchange.getAttribute("WEB_FILTER_CHAIN_KEY");
        ServerHttpRequest newRequest = this.request.mutate().path(path).build();
        ServerWebExchange newExchange = exchange.mutate().request(newRequest).build();
        return chain.filter(newExchange);
    }
}

