/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.cache;

import cn.easyes.common.utils.CollectionUtils;
import cn.easyes.common.utils.ExceptionUtils;
import cn.easyes.core.biz.EntityInfo;
import cn.easyes.core.conditions.BaseEsMapperImpl;
import cn.easyes.core.toolkit.EntityInfoHelper;
import cn.easyes.core.toolkit.FieldUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.client.RestHighLevelClient;

public class BaseCache {
    private static final Map<Class<?>, BaseEsMapperImpl<?>> baseEsMapperInstanceMap = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Method>> baseEsEntityMethodMap = new ConcurrentHashMap();

    public static void initCache(Class<?> mapperInterface, Class<?> entityClass, RestHighLevelClient client) {
        BaseEsMapperImpl baseEsMapper = new BaseEsMapperImpl();
        baseEsMapper.setClient(client);
        baseEsMapper.setEntityClass(entityClass);
        baseEsMapperInstanceMap.put(mapperInterface, baseEsMapper);
        Map<String, Method> invokeMethodsMap = BaseCache.initInvokeMethodsMap(entityClass);
        baseEsEntityMethodMap.putIfAbsent(entityClass, invokeMethodsMap);
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(entityClass);
        Set<Class<?>> allNestedClass = entityInfo.getAllNestedClass();
        if (CollectionUtils.isNotEmpty(allNestedClass)) {
            allNestedClass.forEach(nestedClass -> {
                Map<String, Method> nestedInvokeMethodsMap = BaseCache.initInvokeMethodsMap(nestedClass);
                baseEsEntityMethodMap.putIfAbsent((Class<?>)nestedClass, nestedInvokeMethodsMap);
            });
        }
        Map<String, Method> joinInvokeMethodsMap = BaseCache.initInvokeMethodsMap(entityInfo.getJoinFieldClass());
        baseEsEntityMethodMap.putIfAbsent(entityInfo.getJoinFieldClass(), joinInvokeMethodsMap);
    }

    private static Map<String, Method> initInvokeMethodsMap(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        ConcurrentHashMap<String, Method> invokeMethodsMap = new ConcurrentHashMap<String, Method>(methods.length);
        Arrays.stream(methods).forEach(entityMethod -> {
            String methodName = entityMethod.getName();
            if (methodName.startsWith("get") || methodName.startsWith("is") || methodName.startsWith("set")) {
                invokeMethodsMap.put(methodName, (Method)entityMethod);
            }
        });
        return invokeMethodsMap;
    }

    public static BaseEsMapperImpl<?> getBaseEsMapperInstance(Class<?> mapperInterface) {
        return Optional.ofNullable(baseEsMapperInstanceMap.get(mapperInterface)).orElseThrow(() -> ExceptionUtils.eee((String)"no such instance", (Object[])new Object[]{mapperInterface}));
    }

    public static Method getterMethod(Class<?> entityClass, String methodName) {
        return Optional.ofNullable(baseEsEntityMethodMap.get(entityClass)).map(b -> {
            Method method = (Method)b.get("get" + FieldUtils.firstToUpperCase(methodName));
            if (Objects.isNull(method)) {
                method = (Method)b.get("is" + FieldUtils.firstToUpperCase(methodName));
            }
            return method;
        }).orElseThrow(() -> ExceptionUtils.eee((String)"no such method:", (Object[])new Object[]{entityClass, methodName}));
    }

    public static Method setterMethod(Class<?> entityClass, String methodName) {
        return Optional.ofNullable(baseEsEntityMethodMap.get(entityClass)).map(b -> (Method)b.get("set" + FieldUtils.firstToUpperCase(methodName))).orElseThrow(() -> ExceptionUtils.eee((String)"no such method:", (Object[])new Object[]{entityClass, methodName}));
    }
}

