/*
 * Decompiled with CFR 0.152.
 */
package cn.emay.sdk.client;

import cn.emay.sdk.client.MessageHandler;
import cn.emay.sdk.client.ServiceHandler;
import cn.emay.sdk.client.listener.ReceiveMessageListener;
import cn.emay.sdk.common.SDKProperties;
import cn.emay.sdk.communication.socket.AsynSocketImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HandlerFactory {
    public static MessageHandler getMessageHandler() throws UnknownHostException {
        return HandlerFactory.getMessageHandler(null, null);
    }

    public static MessageHandler getMessageHandler(ReceiveMessageListener rml) throws UnknownHostException {
        return HandlerFactory.getMessageHandler(rml, null);
    }

    public static MessageHandler getMessageHandler(String serverAddr) throws UnknownHostException {
        return HandlerFactory.getMessageHandler(null, serverAddr);
    }

    public static MessageHandler getMessageHandler(ReceiveMessageListener rml, String serverAddr) throws UnknownHostException {
        InetAddress ia = serverAddr == null || "".equals(serverAddr) ? InetAddress.getByName(SDKProperties.SERVERADDR) : InetAddress.getByName(serverAddr);
        return new AsynSocketImpl(rml, ia);
    }

    public static ServiceHandler getServiceHandler(ReceiveMessageListener rml, String serverAddr) throws UnknownHostException {
        InetAddress ia = serverAddr == null || "".equals(serverAddr) ? InetAddress.getByName(SDKProperties.SERVERADDR) : InetAddress.getByName(serverAddr);
        return new AsynSocketImpl(rml, ia);
    }
}

