/*
 * Decompiled with CFR 0.152.
 */
package cn.emay.sdk.client.api;

import cn.emay.sdk.client.HandlerFactory;
import cn.emay.sdk.client.ServiceHandler;
import cn.emay.sdk.client.api.MO;
import cn.emay.sdk.client.api.SDKClient;
import cn.emay.sdk.client.api.StatusReport;
import cn.emay.sdk.client.api.impl.SDKClientImpl;
import cn.emay.sdk.client.listener.ReceiveMessageListener;
import cn.emay.sdk.common.UtilList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    private SDKClient sdkclient;
    private ServiceHandler servicehandler;
    private String softwareSerialNo;
    private String key;

    public Client(String serialNumber, String serialPassword) throws Exception {
        this.softwareSerialNo = serialNumber;
        this.key = serialPassword;
        this.sdkclient = new SDKClientImpl(HandlerFactory.getMessageHandler());
        this.servicehandler = HandlerFactory.getServiceHandler(null, null);
    }

    public Client(String serialNumber, String serialPassword, ReceiveMessageListener listener) throws Exception {
        this.softwareSerialNo = serialNumber;
        this.key = serialPassword;
        this.sdkclient = new SDKClientImpl(HandlerFactory.getMessageHandler(listener, null));
        this.servicehandler = HandlerFactory.getServiceHandler(listener, null);
    }

    public Client(String serialNumber, String serialPassword, ReceiveMessageListener listener, String remotServerIP) throws Exception {
        this.softwareSerialNo = serialNumber;
        this.key = serialPassword;
        this.sdkclient = new SDKClientImpl(HandlerFactory.getMessageHandler(listener, remotServerIP));
        this.servicehandler = HandlerFactory.getServiceHandler(listener, remotServerIP);
    }

    public boolean asynSendSMS(String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority, String smsId) throws Exception {
        return this.sdkclient.asynSendSMS(this.softwareSerialNo, this.key, mobiles, smsContent, addSerial, srcCharset, smsPriority, smsId);
    }

    public boolean asynSendSMS(String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority, String smsId, ReceiveMessageListener rml) throws Exception {
        return this.sdkclient.asynSendSMS(this.softwareSerialNo, this.key, mobiles, smsContent, addSerial, srcCharset, smsPriority, smsId, rml);
    }

    public boolean asynSendSMS(String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority) throws Exception {
        return this.sdkclient.asynSendSMS(this.softwareSerialNo, this.key, mobiles, smsContent, addSerial, srcCharset, smsPriority);
    }

    public int cancelMOForward() {
        return this.sdkclient.cancelMOForward(this.softwareSerialNo, this.key);
    }

    public int chargeUp(String cardNo, String cardPass) {
        return this.sdkclient.chargeUp(this.softwareSerialNo, this.key, cardNo, cardPass);
    }

    public String getBalance() throws Exception {
        return this.sdkclient.getBalanceEx(this.softwareSerialNo, this.key);
    }

    public double getEachFee() {
        return this.sdkclient.getEachFee(this.softwareSerialNo, this.key);
    }

    public String getServiceCode(String serialPassword) {
        return null;
    }

    public List<MO> getMO() throws Exception {
        return this.sdkclient.getMO(this.softwareSerialNo, this.key);
    }

    public UtilList getMOEx() throws Exception {
        return this.sdkclient.getMOEx(this.softwareSerialNo, this.key);
    }

    public List<StatusReport> getReport() throws Exception {
        return this.sdkclient.getReport(this.softwareSerialNo, this.key);
    }

    public UtilList getReportEx() {
        return this.sdkclient.getReportEx(this.softwareSerialNo, this.key);
    }

    public String getVersion() {
        return this.sdkclient.getVersion();
    }

    public int logout() {
        return this.sdkclient.logout(this.softwareSerialNo, this.key);
    }

    public int registDetailInfo(String name, String linkMan, String phoneNum, String mobile, String email, String fax, String address, String postcode) {
        return this.sdkclient.registDetailInfo(this.softwareSerialNo, this.key, name, linkMan, phoneNum, mobile, email, fax, address, postcode);
    }

    public int registEx(String serialpass) {
        return this.sdkclient.registEx(this.softwareSerialNo, this.key, serialpass);
    }

    public int sendSMSEx(String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority, long smsID) {
        return this.sdkclient.sendSMS(this.softwareSerialNo, this.key, mobiles, smsContent, addSerial, srcCharset, smsPriority, smsID);
    }

    public int sendSMSEx(String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority) {
        return this.sdkclient.sendSMS(this.softwareSerialNo, this.key, mobiles, smsContent, addSerial, srcCharset, smsPriority);
    }

    public int sendSMS(String[] mobiles, String smsContent, String addSerial, int smsPriority) {
        return this.sdkclient.sendSMS(this.softwareSerialNo, this.key, mobiles, smsContent, addSerial, smsPriority);
    }

    public int sendSMS(String[] mobiles, String smsContent, int smsPriority) {
        return this.sdkclient.sendSMS(this.softwareSerialNo, this.key, mobiles, smsContent, smsPriority);
    }

    public int sendSMSEx(String[] mobiles, String smsContent, String srcCharset, int smsPriority) {
        return this.sdkclient.sendSMSEx(this.softwareSerialNo, this.key, mobiles, smsContent, srcCharset, smsPriority);
    }

    public int sendScheduledSMS(String[] mobiles, String smsContent, String sendTime, String addSerial, String srcCharset) {
        return this.sdkclient.sendScheduledSMS(this.softwareSerialNo, this.key, mobiles, smsContent, sendTime, addSerial, srcCharset);
    }

    public int sendScheduledSMS(String[] mobiles, String smsContent, String sendTime, String addSerial) {
        return this.sdkclient.sendScheduledSMS(this.softwareSerialNo, this.key, mobiles, smsContent, sendTime, addSerial);
    }

    public int sendScheduledSMS(String[] mobiles, String smsContent, String sendTime) {
        return this.sdkclient.sendScheduledSMS(this.softwareSerialNo, this.key, mobiles, smsContent, sendTime);
    }

    public int sendScheduledSMSEx(String[] mobiles, String smsContent, String sendTime, String srcCharset) {
        return this.sdkclient.sendScheduledSMSEx(this.softwareSerialNo, this.key, mobiles, smsContent, sendTime, srcCharset);
    }

    public int serialPwdUpd(String serialPwd, String serialPwdNew) {
        return this.sdkclient.serialPwdUpd(this.softwareSerialNo, this.key, serialPwd, serialPwdNew);
    }

    public int setMOForward(String forwardMobile) {
        return this.sdkclient.setMOForward(this.softwareSerialNo, this.key, forwardMobile);
    }

    public int setMOForwardEx(String[] forwardMobile) {
        return this.sdkclient.setMOForwardEx(this.softwareSerialNo, this.key, forwardMobile);
    }

    public void closeSocketConnect() throws Exception {
        this.servicehandler.stopServiceThread();
    }

    public void closeRemoteSocket() throws Exception {
        this.servicehandler.stopServiceThread();
    }
}

