/*
 * Decompiled with CFR 0.152.
 */
package cn.emay.sdk.client.api.impl;

import cn.emay.sdk.client.MessageHandler;
import cn.emay.sdk.client.api.MO;
import cn.emay.sdk.client.api.SDKClient;
import cn.emay.sdk.client.api.StatusReport;
import cn.emay.sdk.client.listener.ReceiveMessageListener;
import cn.emay.sdk.common.SDKProperties;
import cn.emay.sdk.common.UtilList;
import cn.emay.sdk.communication.util.Base64;
import cn.emay.sdk.communication.util.Verify;
import cn.emay.sdk.exceptions.ErrorMobilesException;
import cn.emay.sdk.exceptions.PropertyMaxLengthException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKClientImpl
implements SDKClient {
    Log logger = LogFactory.getLog(SDKClientImpl.class);
    private String serviceType = "01";
    private MessageHandler messagehandler;

    public SDKClientImpl(MessageHandler messagehandler) {
        this.messagehandler = messagehandler;
    }

    @Override
    public int registEx(String softwareSerialNo, String key, String serialpass) {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        serialpass = Verify.propertiesVerify(serialpass);
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType + "," + key.trim() + "," + serialpass.trim() + ",4.0.4_WebService";
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C001-")) + "," + keyId.trim() + ",SYNC@";
        return this.sendMessage(keyId, msg, 0);
    }

    @Override
    public boolean asynSendSMS(String softwareSerialNo, String key, String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority, String smsId) throws Exception {
        return this.asynSendSMS(softwareSerialNo, key, mobiles, smsContent, addSerial, srcCharset, smsPriority, smsId, null);
    }

    @Override
    public boolean asynSendSMS(String softwareSerialNo, String key, String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority, String smsId, ReceiveMessageListener rml) throws Exception {
        String tmpmobiles;
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        smsContent = Verify.propertiesVerify(smsContent);
        addSerial = Verify.maxLang(addSerial, 15, "\u9644\u52a0\u7801");
        srcCharset = Verify.propertiesVerify(srcCharset);
        try {
            smsId = Verify.seqIDVerify(smsId);
        }
        catch (PropertyMaxLengthException e) {
            e.printStackTrace();
            this.logger.warn((Object)"\u552f\u4e00\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e14\u4f4d,\u5df2\u5c06\u552f\u4e00\u7801\u66ff\u6362\u4e3a\u7cfb\u7edf\u751f\u6210\u552f\u4e00\u7801!");
            smsId = Verify.getSeqID();
        }
        if (this.isContentOverflow(smsContent)) {
            return false;
        }
        try {
            tmpmobiles = Verify.mobilesVerify(mobiles);
        }
        catch (ErrorMobilesException e) {
            this.logger.warn((Object)"\u76ee\u6807\u624b\u673a\u53f7\u7801\u4e0d\u7b26\u5408\u89c4\u683c");
            e.printStackTrace();
            return false;
        }
        String message = String.valueOf(softwareSerialNo.trim()) + "," + (smsPriority > 5 ? 5 : smsPriority) + "," + key.trim() + "," + smsId.trim() + "," + addSerial.trim() + "," + srcCharset.trim() + "," + tmpmobiles.trim() + "," + smsContent.trim();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C002-")) + "," + smsId.trim() + ",SYNC@";
        return this.messagehandler == null ? false : this.messagehandler.asynSendMessage(smsId, msg, rml);
    }

    @Override
    public boolean asynSendSMS(String softwareSerialNo, String key, String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority) throws Exception {
        return this.asynSendSMS(softwareSerialNo, key, mobiles, smsContent, addSerial, srcCharset, smsPriority, null);
    }

    public int sendSMS1(String softwareSerialNo, String key, String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority, long smsID) {
        String tmpmobiles;
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        smsContent = Verify.propertiesVerify(smsContent);
        addSerial = Verify.propertiesVerify(addSerial);
        srcCharset = Verify.propertiesVerify(srcCharset);
        if (this.isContentOverflow(smsContent)) {
            return -1;
        }
        try {
            tmpmobiles = Verify.mobilesVerify(mobiles);
        }
        catch (ErrorMobilesException e) {
            e.printStackTrace();
            this.logger.warn((Object)e);
            return 307;
        }
        this.logger.debug((Object)("send mobiles:" + tmpmobiles));
        String keyId = "";
        try {
            keyId = Verify.seqIDVerify("" + smsID);
        }
        catch (PropertyMaxLengthException e) {
            e.printStackTrace();
            this.logger.warn((Object)"\u552f\u4e00\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e14\u4f4d,\u5df2\u5c06\u552f\u4e00\u7801\u66ff\u6362\u4e3a\u7cfb\u7edf\u751f\u6210\u552f\u4e00\u7801!");
            keyId = Verify.getSeqID();
        }
        String message = String.valueOf(softwareSerialNo.trim()) + "," + (smsPriority > 5 ? 5 : smsPriority) + "," + key.trim() + "," + keyId.trim() + "," + addSerial.trim() + "," + srcCharset.trim() + "," + tmpmobiles.trim() + "," + smsContent.trim();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C002-")) + "," + keyId.trim() + ",SYNC@";
        int i = this.sendMessage(keyId, msg, 0);
        return i == 303 ? 0 : i;
    }

    @Override
    public int sendSMS(String softwareSerialNo, String key, String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority, long smsID) {
        String tmpmobiles;
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        smsContent = Verify.propertiesVerify(smsContent);
        addSerial = Verify.propertiesVerify(addSerial);
        srcCharset = Verify.propertiesVerify(srcCharset);
        if (this.isContentOverflow(smsContent)) {
            return -1;
        }
        try {
            tmpmobiles = Verify.mobilesVerify(mobiles);
        }
        catch (ErrorMobilesException e) {
            e.printStackTrace();
            this.logger.warn((Object)e);
            return 307;
        }
        this.logger.debug((Object)("send mobiles:" + tmpmobiles));
        String keyId = "";
        try {
            keyId = "5" + Verify.seqIDVerify("0") + "2";
        }
        catch (PropertyMaxLengthException e) {
            e.printStackTrace();
            this.logger.warn((Object)"\u552f\u4e00\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e14\u4f4d,\u5df2\u5c06\u552f\u4e00\u7801\u66ff\u6362\u4e3a\u7cfb\u7edf\u751f\u6210\u552f\u4e00\u7801!");
            keyId = "5" + Verify.getSeqID() + "2";
        }
        String message = String.valueOf(softwareSerialNo.trim()) + "," + (smsPriority > 5 ? 5 : smsPriority) + "," + key.trim() + "," + smsID + "," + addSerial.trim() + "," + srcCharset.trim() + "," + tmpmobiles.trim() + "," + smsContent.trim();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C002-")) + "," + keyId.trim() + ",SYNC@";
        return this.sendMessage(keyId, msg, 0);
    }

    @Override
    public int sendSMS(String softwareSerialNo, String key, String[] mobiles, String smsContent, String addSerial, String srcCharset, int smsPriority) {
        return this.sendSMS(softwareSerialNo, key, mobiles, smsContent, addSerial, srcCharset, smsPriority, 0L);
    }

    @Override
    public int sendSMSEx(String softwareSerialNo, String key, String[] mobiles, String smsContent, String srcCharset, int smsPriority) {
        return this.sendSMS(softwareSerialNo, key, mobiles, smsContent, "", srcCharset, smsPriority);
    }

    @Override
    public int sendSMS(String softwareSerialNo, String key, String[] mobiles, String smsContent, String addSerial, int smsPriority) {
        return this.sendSMS(softwareSerialNo, key, mobiles, smsContent, addSerial, "GBK", smsPriority);
    }

    @Override
    public int sendSMS(String softwareSerialNo, String key, String[] mobiles, String smsContent, int smsPriority) {
        return this.sendSMSEx(softwareSerialNo, key, mobiles, smsContent, "GBK", smsPriority);
    }

    @Override
    public int sendScheduledSMS(String softwareSerialNo, String key, String[] mobiles, String smsContent, String sendTime, String addSerial, String srcCharset) {
        String tmpmobiles;
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        smsContent = Verify.propertiesVerify(smsContent);
        sendTime = Verify.propertiesVerify(sendTime);
        addSerial = Verify.propertiesVerify(addSerial);
        srcCharset = Verify.propertiesVerify(srcCharset);
        if (this.isContentOverflow(smsContent)) {
            return -1;
        }
        try {
            tmpmobiles = Verify.mobilesVerify(mobiles);
        }
        catch (ErrorMobilesException e) {
            e.printStackTrace();
            this.logger.warn((Object)e);
            return 307;
        }
        String keyId = Verify.getSeqID();
        String message = String.valueOf(softwareSerialNo.trim()) + "," + sendTime.trim() + "," + key.trim() + "," + keyId.trim() + "," + addSerial.trim() + "," + srcCharset.trim() + "," + tmpmobiles.trim() + "," + smsContent.trim();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C003-")) + "," + keyId + ",SYNC@";
        return this.sendMessage(keyId, msg, 0);
    }

    @Override
    public int sendScheduledSMS(String softwareSerialNo, String key, String[] mobiles, String smsContent, String sendTime, String addSerial) {
        return this.sendScheduledSMS(softwareSerialNo, key, mobiles, smsContent, sendTime, addSerial, "GBK");
    }

    @Override
    public int sendScheduledSMSEx(String softwareSerialNo, String key, String[] mobiles, String smsContent, String sendTime, String srcCharset) {
        return this.sendScheduledSMS(softwareSerialNo, key, mobiles, smsContent, sendTime, "", srcCharset);
    }

    @Override
    public int sendScheduledSMS(String softwareSerialNo, String key, String[] mobiles, String smsContent, String sendTime) {
        return this.sendScheduledSMS(softwareSerialNo, key, mobiles, smsContent, sendTime, "");
    }

    @Override
    public int chargeUp(String softwareSerialNo, String key, String cardNo, String cardPass) {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        cardNo = Verify.propertiesVerify(cardNo);
        cardPass = Verify.propertiesVerify(cardPass);
        String message = String.valueOf(softwareSerialNo.trim()) + "," + cardNo.trim() + "," + key.trim() + "," + cardPass.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C004-")) + "," + keyId.trim() + ",SYNC@";
        return this.sendMessage(keyId, msg, 0);
    }

    @Override
    public int logout(String softwareSerialNo, String key) {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType.trim() + "," + key.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C005-")) + "," + keyId + ",SYNC@";
        return this.sendMessage(keyId, msg, 0);
    }

    @Override
    public int registDetailInfo(String softwareSerialNo, String serialPwd, String eName, String linkMan, String phoneNum, String mobile, String email, String fax, String address, String postcode) {
        String tmpmobiles;
        if (eName == null || linkMan == null || phoneNum == null || mobile == null || email == null || fax == null || address == null || postcode == null || "".equals(eName) || "".equals(linkMan) || "".equals(phoneNum) || "".equals(mobile) || "".equals(email) || "".equals(fax) || "".equals(address) || "".equals(postcode)) {
            return -1;
        }
        if (linkMan.length() > 20 || eName.length() > 255 || phoneNum.length() > 20 || mobile.length() > 20 || email.length() > 60 || fax.length() > 20 || address.length() > 80 || postcode.length() > 6) {
            return -1;
        }
        try {
            tmpmobiles = Verify.mobilesVerify(mobile);
        }
        catch (ErrorMobilesException e) {
            e.printStackTrace();
            this.logger.warn((Object)e);
            return 307;
        }
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType.trim() + "," + serialPwd.trim() + "," + eName.trim() + "," + linkMan.trim() + "," + phoneNum.trim() + "," + tmpmobiles.trim() + "," + email.trim() + "," + fax.trim() + "," + address.trim() + "," + postcode.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C006-")) + "," + keyId + ",SYNC@";
        return this.sendMessage(keyId, msg, 0);
    }

    @Override
    public int serialPwdUpd(String softwareSerialNo, String key, String serialPwd, String serialPwdNew) {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        try {
            serialPwdNew = Verify.maxLang(serialPwdNew, 6, "\u65b0\u5bc6\u7801\u957f\u5ea6");
        }
        catch (PropertyMaxLengthException e1) {
            this.logger.warn((Object)"\u65b0\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e6\u4f4d");
            e1.printStackTrace();
        }
        if (serialPwdNew.length() > 6) {
            return -1;
        }
        try {
            Integer.parseInt(serialPwdNew);
        }
        catch (NumberFormatException e) {
            this.logger.warn((Object)"\u4fee\u6539\u7684\u5bc6\u7801\u5fc5\u987b\u4e3a\u6570\u5b57!");
            e.printStackTrace();
            return 308;
        }
        String message = String.valueOf(softwareSerialNo.trim()) + "," + serialPwd.trim() + "," + key.trim() + "," + serialPwdNew.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C007-")) + "," + keyId + ",SYNC@";
        return this.sendMessage(keyId, msg, 0);
    }

    @Override
    public int setMOForward(String softwareSerialNo, String key, String forwardMobile) {
        String tmpmobiles;
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        forwardMobile = Verify.propertiesVerify(forwardMobile);
        try {
            tmpmobiles = Verify.mobilesVerify(forwardMobile);
        }
        catch (ErrorMobilesException e) {
            e.printStackTrace();
            this.logger.warn((Object)e);
            return 307;
        }
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType.trim() + "," + key.trim() + "," + tmpmobiles.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C009-")) + "," + keyId + ",SYNC@";
        return this.sendMessage(keyId, msg, 0);
    }

    @Override
    public int setMOForwardEx(String softwareSerialNo, String key, String[] forwardMobile) {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        StringBuilder tmpmobilest = new StringBuilder();
        String[] stringArray = forwardMobile;
        int n = forwardMobile.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            try {
                tmpmobilest.append(Verify.mobilesVerify(s));
            }
            catch (ErrorMobilesException e) {
                e.printStackTrace();
                this.logger.warn((Object)e);
                return 307;
            }
            tmpmobilest.append(",");
            ++n2;
        }
        tmpmobilest.deleteCharAt(tmpmobilest.length() - 1);
        String tmpmobiles = tmpmobilest.toString();
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType.trim() + "," + key.trim() + "," + tmpmobiles.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C010-")) + "," + keyId + ",SYNC@";
        return this.sendMessage(keyId, msg, 0);
    }

    @Override
    public int cancelMOForward(String softwareSerialNo, String key) {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType.trim() + "," + key.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C008-")) + "," + keyId + ",SYNC@";
        return this.sendMessage(keyId, msg, 0);
    }

    @Override
    public double getBalance(String softwareSerialNo, String key) throws Exception {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType.trim() + "," + key.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C011-")) + "," + keyId + ",SYNC@";
        return this.selectBalance(keyId, msg, 0);
    }

    @Override
    public String getBalanceEx(String softwareSerialNo, String key) throws Exception {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType.trim() + "," + key.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C011-")) + "," + keyId + ",SYNC@";
        return this.selectBalanceEx(keyId, msg, 0);
    }

    @Override
    public double getEachFee(String softwareSerialNo, String key) {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType.trim() + "," + key.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg4(message, "SYNC-C012-")) + "," + keyId + ",SYNC@";
        return this.selectBalance(keyId, msg, 0);
    }

    @Override
    public List<MO> getMO(String softwareSerialNo, String key) throws Exception {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        UtilList ul = null;
        ArrayList<MO> moAList = new ArrayList<MO>();
        ul = this.getMOEx(softwareSerialNo.trim(), key.trim());
        int index = 0;
        while (ul != null && index < ul.size()) {
            MO mo = (MO)ul.get(index);
            moAList.add(mo);
            ++index;
        }
        return moAList;
    }

    @Override
    public UtilList getMOEx(String softwareSerialNo, String key) throws Exception {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType.trim() + "," + key.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg8(message, "MOANDRPT-C013-")) + "," + keyId + ",SYNC@";
        return this.selectMO(keyId, msg, 0);
    }

    @Override
    public List<StatusReport> getReport(String softwareSerialNo, String key) throws Exception {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        ArrayList<StatusReport> reportAList = new ArrayList<StatusReport>();
        UtilList ul = this.getReportEx(softwareSerialNo.trim(), key.trim());
        int index = 0;
        while (ul != null && index < ul.size()) {
            StatusReport statusReport = (StatusReport)ul.get(index);
            reportAList.add(statusReport);
            ++index;
        }
        return reportAList;
    }

    @Override
    public UtilList getReportEx(String softwareSerialNo, String key) {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        String message = String.valueOf(softwareSerialNo.trim()) + "," + this.serviceType.trim() + "," + key.trim();
        String keyId = Verify.getSeqID();
        String msg = String.valueOf(this.chuliMsg8(message, "MOANDRPT-C014-")) + "," + keyId + ",SYNC@";
        return this.selectMO(keyId, msg, 0);
    }

    @Override
    public String getVersion() {
        return SDKProperties.version;
    }

    private boolean isContentOverflow(String smsText) {
        if (smsText.length() == smsText.getBytes().length) {
            if (smsText.length() > 1000) {
                this.logger.info((Object)"\u77ed\u4fe1\u5185\u5bb9\u957f\u5ea6\u8d8a\u754c\uff0c\u6c49\u5b57\u4e0d\u80fd\u8d85\u8fc7500\u5b57\u53ca\u7b26\u53f7\uff0c\u82f1\u6587\u4e0d\u80fd\u8d85\u8fc71000\u4e2a\u5b57\u6bcd\u53ca\u7b26\u53f7\uff01");
                return true;
            }
        } else if (smsText.length() > 500) {
            this.logger.info((Object)"\u77ed\u4fe1\u5185\u5bb9\u957f\u5ea6\u8d8a\u754c\uff0c\u6c49\u5b57\u4e0d\u80fd\u8d85\u8fc7500\u5b57\u53ca\u7b26\u53f7\uff0c\u82f1\u6587\u4e0d\u80fd\u8d85\u8fc71000\u4e2a\u5b57\u6bcd\u53ca\u7b26\u53f7\uff01");
            return true;
        }
        return false;
    }

    private UtilList getMOList(String data) {
        String dataTemp = Base64.base64ToStr(data);
        String[] datas = dataTemp.split(",");
        if (datas == null) {
            return null;
        }
        if (datas[0].equals("0")) {
            return null;
        }
        UtilList ul = new UtilList();
        if (datas.length > 3) {
            ul.setHaveNext(Integer.parseInt(datas[1]) == 1);
            datas[3] = datas[3].replace(";", ",");
            String[] mos = datas[3].split(",");
            int i = 0;
            while (mos != null && i < mos.length) {
                MO mo = new MO();
                mos[i] = mos[i].replace(".", ",");
                String[] aMO = mos[i].split(",");
                mo.setAddSerial(aMO[5]);
                mo.setAddSerialRev(aMO[7]);
                mo.setMobileNumber(aMO[8]);
                mo.setSentTime(aMO[3]);
                mo.setSmsContent(aMO[2]);
                mo.setChannelnumber(aMO[9]);
                ul.add(mo);
                ++i;
            }
        }
        return ul;
    }

    private UtilList getRptList(String data) {
        String dataTemp = Base64.base64ToStr(data);
        String[] datas = dataTemp.split(",");
        if (datas == null) {
            return null;
        }
        if (datas[0].equals("0")) {
            return null;
        }
        UtilList ul = new UtilList();
        if (datas.length > 3) {
            ul.setHaveNext(Integer.parseInt(datas[1]) == 1);
            datas[3] = datas[3].replace(";", ",");
            String[] rpts = datas[3].split(",");
            int i = 0;
            while (rpts != null && i < rpts.length) {
                StatusReport rpt = new StatusReport();
                rpts[i] = rpts[i].replace(".", ",");
                String[] aRpt = rpts[i].split(",");
                rpt.setErrorCode(aRpt[0]);
                rpt.setMemo(aRpt[2]);
                rpt.setMobile(aRpt[8]);
                rpt.setReceiveDate(aRpt[3]);
                rpt.setReportStatus(Integer.parseInt(aRpt[4]));
                rpt.setSeqID(Long.parseLong(aRpt[5]));
                rpt.setServiceCodeAdd(aRpt[6]);
                rpt.setSubmitDate(aRpt[7]);
                ul.add(rpt);
                ++i;
            }
        }
        return ul;
    }

    private String chuliMsg4(String msg, String type) {
        String message = "";
        try {
            message = Base64.base64Str(msg.getBytes("GBK"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        message = message.replace("\r\n", "");
        message = message.replace("\n", "");
        int msgLength = message.length();
        message = String.valueOf(type) + message;
        String temp = "[A-Z]{4}\\-C\\d{3}-[A-Z|0-9|a-z|+|/|=]{" + msgLength + "}";
        return String.valueOf(temp) + "," + message;
    }

    private String chuliMsg8(String msg, String type) {
        String message = "";
        try {
            message = Base64.base64Str(msg.getBytes("GBK"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        message = message.replace("\r\n", "");
        message = message.replace("\n", "");
        int msgLength = message.length();
        message = String.valueOf(type) + message;
        String temp = "[A-Z]{8}\\-C\\d{3}-[A-Z|0-9|a-z|+|/|=]{" + msgLength + "}";
        return String.valueOf(temp) + "," + message;
    }

    private int sendMessage(String key, String message, int sendTimes) {
        int resp;
        String response = this.messagehandler.getResponse(key, message);
        try {
            resp = Integer.parseInt(response);
        }
        catch (NumberFormatException e) {
            this.logger.warn((Object)e);
            resp = 305;
        }
        return resp;
    }

    private double selectBalance(String key, String message, int sendTimes) {
        double state = 0.0;
        try {
            String[] respDatas = this.messagehandler.getResponse(key, message).split(",");
            String returnValue = respDatas[0];
            state = this.messagehandler.isSuccCheckData("[0-9|.]{" + returnValue.length() + "}", returnValue) ? Double.parseDouble(returnValue) : 0.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    private String selectBalanceEx(String key, String message, int sendTimes) {
        String state = "";
        try {
            String[] respDatas = this.messagehandler.getResponse(key, message).split(",");
            String returnValue = respDatas[0];
            state = this.messagehandler.isSuccCheckData("[0-9|.]{" + returnValue.length() + "}", returnValue) ? returnValue : "308";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    /*
     * Unable to fully structure code
     */
    private UtilList selectMO(String key, String message, int sendTimes) {
        response = this.messagehandler.getResponse(key, message).replace(".", ",");
        respDatas = response.split(",");
        try {
            if ("R001".equals(respDatas[1].substring(0, 4))) {
                return this.getMOList(respDatas[1].substring(5, respDatas[1].length()));
            }
            if ("R002".equals(respDatas[1].substring(0, 4))) {
                return this.getRptList(respDatas[1].substring(5, respDatas[1].length()));
            }
            return null;
        }
        catch (Exception e) {
            this.logger.warn((Object)e);
            var10_7 = respDatas;
            var9_8 = respDatas.length;
            var8_9 = 0;
            ** while (var8_9 < var9_8)
        }
lbl-1000:
        // 1 sources

        {
            a = var10_7[var8_9];
            this.logger.info((Object)("\u8fd4\u56de\u7684\u9519\u8bef\u7801\u662f:" + a));
            ++var8_9;
            continue;
        }
lbl19:
        // 1 sources

        return null;
    }

    public String getMOString(String softwareSerialNo, String key) throws Exception {
        softwareSerialNo = Verify.propertiesVerify(softwareSerialNo);
        key = Verify.propertiesVerify(key);
        ArrayList<MO> moAList = new ArrayList<MO>();
        UtilList ul = null;
        while (ul.isHaveNext()) {
            ul = this.getMOEx(softwareSerialNo.trim(), key.trim());
            if (ul == null) break;
            for (Object object : ul) {
                moAList.add((MO)object);
            }
        }
        String contentString = "";
        for (MO object : moAList) {
            contentString = String.valueOf(contentString) + object.getAddSerial() + "," + object.getAddSerialRev() + "," + object.getChannelnumber() + "," + object.getMobileNumber() + "," + object.getSentTime() + "," + Base64.base64Str(object.getSmsContent().getBytes("GBK")) + ",@";
        }
        return contentString;
    }
}

