/*
 * Decompiled with CFR 0.152.
 */
package cn.emay.sdk.communication.socket;

import cn.emay.sdk.communication.socket.socketSimulative.ServiceState;
import cn.emay.sdk.exceptions.CloseConnectionException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AsynSocket {
    Log logger = LogFactory.getLog(AsynSocket.class);
    private SocketChannel socketChannel;
    private Selector selector;
    private InetAddress inetaddress;
    private int port;

    public AsynSocket(InetAddress inetaddress, int port) {
        this.inetaddress = inetaddress;
        this.port = port;
        Thread thread = new Thread((Runnable)new CheckConnection(), "\u94fe\u8def\u68c0\u6d4b");
        thread.start();
    }

    private synchronized boolean connectServer() {
        boolean state = false;
        try {
            if (this.isConnection()) {
                state = true;
                return true;
            }
            InetSocketAddress inetsocketaddress = new InetSocketAddress(this.inetaddress, this.port);
            this.socketChannel = SocketChannel.open(inetsocketaddress);
            this.socketChannel.socket().setSoTimeout(0);
            this.socketChannel.configureBlocking(false);
            this.selector = Selector.open();
            this.socketChannel.register(this.selector, 5);
            this.logger.info((Object)("SDKServer:" + this.inetaddress + " connected !"));
            while (!this.socketChannel.finishConnect()) {
            }
            ByteBuffer buffer = ByteBuffer.allocate(1);
            this.socketChannel.read(buffer);
            ServiceState.Connection = 0;
        }
        catch (Exception e) {
            try {
                this.socketChannel.close();
                this.selector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.error((Object)("fail connect SDKServer:" + this.inetaddress + "\uff01reconnecting ..."));
        }
        return state;
    }

    public ByteBuffer receive(SelectionKey key, ByteBuffer receiveBuffer) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        int i = socketChannel.read(receiveBuffer);
        if (i == -1) {
            throw new CloseConnectionException();
        }
        return receiveBuffer.hasArray() ? receiveBuffer : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SelectionKey key, ByteBuffer sendBuffer) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        ByteBuffer byteBuffer = sendBuffer;
        synchronized (byteBuffer) {
            if (sendBuffer.position() > 0) {
                sendBuffer.flip();
                socketChannel.write(sendBuffer);
                sendBuffer.compact();
            }
            sendBuffer.notifyAll();
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public boolean isConnection() {
        boolean s = false;
        try {
            s = this.socketChannel.isConnected();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    class CheckConnection
    implements Runnable {
        CheckConnection() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        int n = ServiceState.Connection = AsynSocket.this.isConnection() ? 0 : 1;
                        if (ServiceState.Connection == 1) {
                            AsynSocket.this.connectServer();
                        } else {
                            ServiceState._Notify_Lock();
                        }
                        Thread.sleep(500L);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }
}

