/*
 * Decompiled with CFR 0.152.
 */
package cn.emay.sdk.communication.socket;

import cn.emay.sdk.client.MessageHandler;
import cn.emay.sdk.client.ServiceHandler;
import cn.emay.sdk.client.listener.ReceiveMessageListener;
import cn.emay.sdk.common.SDKProperties;
import cn.emay.sdk.communication.socket.AbstractAsynSocket;
import cn.emay.sdk.communication.socket.Observer;
import cn.emay.sdk.communication.socket.ResponseMsg;
import cn.emay.sdk.communication.socket.ServiceGroup;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynSocketImpl
extends AbstractAsynSocket
implements MessageHandler,
ServiceHandler {
    Log logger = LogFactory.getLog(AsynSocketImpl.class);
    private Map<String, Observer> observerMap = new PooledMap<String, Observer>();
    private Map<String, String> syncMsgMap = new PooledMap<String, String>();
    private Map<String, String> windowMsgMap = new PooledMap<String, String>();
    private final String code55 = new Integer(306).toString();
    private ReceiveMessageListener receivemessagelistener;
    private Charset charset = Charset.forName(SDKProperties.CHARSETCODE);
    private static volatile AsynSocketImpl asynsocketimpl;
    private ServiceGroup ServiceGroup;

    public AsynSocketImpl(ReceiveMessageListener listener, InetAddress inetaddress) throws UnknownHostException {
        super(inetaddress, SDKProperties.SERVERPORT);
        this.receivemessagelistener = listener;
        this.ServiceGroup = new ServiceGroup(this);
        this.ServiceGroup.startServiceThread();
    }

    public static synchronized AsynSocketImpl getAsynSocketImpl(ReceiveMessageListener listener, InetAddress inetaddress) throws UnknownHostException {
        return asynsocketimpl == null ? (asynsocketimpl = new AsynSocketImpl(listener, inetaddress)) : asynsocketimpl;
    }

    @Override
    public void syncSendMessage(String key, String msg) {
        try {
            this.resizeBuffer(super.getSendBuffer(), this.encode(msg, SDKProperties.BYTECODE).length);
            super.getSendBuffer().put(this.encode(msg, SDKProperties.BYTECODE));
        }
        catch (Exception e) {
            if (SDKProperties.SENDRECEIVESPEED > 2) {
                this.logger.info((Object)("\u53d1\u9001\u961f\u5217\u6ee1!\u589e\u5feb\u53d1\u9001\u9891\u7387\u4e3a:" + --SDKProperties.SENDRECEIVESPEED + "\u6beb\u79d2"));
            }
            this.logger.error((Object)e);
            if (msg.indexOf("ASYN") != -1) {
                this.notifyObserver(key, this.code55);
            } else {
                this.windowMsgMap.put(key, this.code55);
            }
            return;
        }
    }

    @Override
    public boolean asynSendMessage(String key, String msg, ReceiveMessageListener receivemessagelistener) {
        Observer observer = new Observer(receivemessagelistener);
        this.addSendMessage(key, observer);
        String response = this.getResponse(key, msg);
        int resp = 1;
        try {
            resp = Integer.parseInt(response);
        }
        catch (NumberFormatException e) {
            this.logger.warn((Object)e);
            resp = 305;
        }
        return resp == 0;
    }

    @Override
    public boolean asynSendMessage(String key, String msg) {
        return this.asynSendMessage(key, msg, null);
    }

    @Override
    public Map<String, String> getSyncMsgMap() {
        return this.syncMsgMap;
    }

    @Override
    public synchronized String getResponse(String key, String message) {
        this.logger.debug((Object)("\u53d1\u9001\u6570\u636e" + message));
        long TimeOut = 0L;
        this.syncSendMessage(key, message);
        TimeOut = 0L;
        String response = null;
        while (response == null) {
            response = this.windowMsgMap.remove(key);
            if (response != null && this.code55.equals(response)) {
                return response;
            }
            response = this.getSyncMsgMap().remove(key);
            if (++TimeOut > (long)SDKProperties.WAITRESPONSETIME) {
                this.logger.info((Object)"CLIENT Time Out,return\uff1a303");
                return "303";
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.notifyAll();
        return response;
    }

    @Override
    void chuliReceive(ByteBuffer receiveBuffer) {
        receiveBuffer.flip();
        String receiveData = this.decode(receiveBuffer);
        if (receiveData.indexOf("@") == -1) {
            receiveBuffer.mark();
            return;
        }
        String tempData = "";
        while (receiveData.indexOf("@") > -1) {
            int index = receiveData.indexOf("@") + 1;
            String outputData = receiveData.substring(0, index);
            tempData = String.valueOf(tempData) + outputData;
            this.logger.debug((Object)("\u6536\u5230\u7684\u6570\u636e" + tempData));
            String[] aData = outputData.split(",");
            if (aData.length == 5) {
                if ("SYNC@".equals(aData[4]) || "ACTI@".equals(aData[4]) || "AUTOMATON@".equals(aData[4])) {
                    this.logger.debug((Object)("SEQID:\u63a5\u6536\u5230\u540c\u6b65\u6d88\u606f\u8fd4\u56deid\u662f" + aData[3]));
                    this.syncMsgMap.put(aData[3], aData[0]);
                } else {
                    this.logger.debug((Object)("SEQID:\u63a5\u6536\u5230\u5f02\u6b65\u6d88\u606f\u8fd4\u56deid\u662f" + aData[3]));
                    this.notifyObserver(aData[3], aData[0]);
                    this.syncMsgMap.put(aData[3], aData[0]);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                String[] stringArray = aData;
                int n = aData.length;
                int n2 = 0;
                while (n2 < n) {
                    String data = stringArray[n2];
                    sb.append(data);
                    ++n2;
                }
                this.logger.debug((Object)("\u63a5\u6536\u7684\u6570\u636e\u4e0d\u662f\u5b8c\u6574\u7684:" + sb.toString()));
            }
            receiveData = receiveData.substring(index, receiveData.length());
            receiveBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObserver(String key, String result) {
        Map<String, Observer> map = this.observerMap;
        synchronized (map) {
            Observer observer = this.observerMap.get(key);
            if (observer != null) {
                this.delSendMessage(key);
                ResponseMsg rm = new ResponseMsg();
                rm.setResult(result);
                rm.setSmsId(key);
                this.sendListener(observer, rm);
                this.observerMap.remove(key);
            }
            this.observerMap.notifyAll();
        }
    }

    @Override
    public boolean isSuccCheckData(String express, String rptCode) {
        Pattern p1 = Pattern.compile(express);
        Matcher m1 = p1.matcher(rptCode);
        boolean rs1 = m1.matches();
        return rs1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSendMessage(String key, Observer observer) {
        this.observerMap.clear();
        Map<String, Observer> map = this.observerMap;
        synchronized (map) {
            this.observerMap.put(key, observer);
            this.observerMap.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Observer delSendMessage(String key) {
        Map<String, Observer> map = this.observerMap;
        synchronized (map) {
            Observer o = this.observerMap.remove(key);
            this.observerMap.notifyAll();
            return o;
        }
    }

    private void sendListener(Observer observer, ResponseMsg rm) {
        if (observer.getReceivemessagelistener() != null) {
            observer.getReceivemessagelistener().onReceive(rm);
        }
        if (this.receivemessagelistener != null) {
            this.receivemessagelistener.onReceive(rm);
        }
    }

    private ByteBuffer encode(String string) {
        return this.charset.encode(string);
    }

    private byte[] encode(String string, String coding) {
        try {
            return string.getBytes(coding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String decode(ByteBuffer buffer) {
        CharBuffer charBuffer = this.charset.decode(buffer);
        return charBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTimeOutData() {
        Map<String, Observer> map = this.observerMap;
        synchronized (map) {
            block5: {
                if (this.observerMap.size() <= 0) break block5;
                Set<String> keySet = this.observerMap.keySet();
                Iterator<String> it = keySet.iterator();
                ArrayList<String> timeOutKeys = new ArrayList<String>();
                while (it.hasNext()) {
                    String key = it.next();
                    Observer o = this.observerMap.get(key);
                    this.observerMap.remove(key);
                    if (System.currentTimeMillis() - o.getSendTime() <= SDKProperties.ClearTimeoutDateTime) continue;
                    timeOutKeys.add(key);
                }
                this.getCommunicationFailData(timeOutKeys);
                this.observerMap.notifyAll();
                return true;
            }
            this.observerMap.notifyAll();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCommunicationFailData() {
        Map<String, Observer> map = this.observerMap;
        synchronized (map) {
            if (this.observerMap.size() > 0) {
                Set<String> keySet = this.observerMap.keySet();
                for (String key : keySet) {
                    ResponseMsg rm = new ResponseMsg();
                    this.logger.info((Object)("SOCKETFAILED smsId:" + key));
                    rm.setResult("303");
                    rm.setSmsId(key);
                    Observer observer = this.observerMap.get(key);
                    this.sendListener(observer, rm);
                }
                this.observerMap.clear();
            }
            this.observerMap.notifyAll();
        }
    }

    private void getCommunicationFailData(List<String> list) {
        for (String key : list) {
            ResponseMsg rm = new ResponseMsg();
            this.logger.info((Object)("getCommunicationFailData smsId:" + key));
            rm.setResult("303");
            rm.setSmsId(key);
            Observer observer = this.delSendMessage(key);
            this.sendListener(observer, rm);
        }
    }

    @Override
    public void startServiceThread() {
    }

    @Override
    public void stopServiceThread() {
    }

    public class Notify
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Set _set = AsynSocketImpl.this.windowMsgMap.keySet();
                        Iterator iterator = _set.iterator();
                        while (iterator.hasNext()) {
                            String string;
                            String string2 = string = (String)iterator.next();
                            synchronized (string2) {
                                string.notify();
                            }
                        }
                        Thread.sleep(1L);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PooledMap<Key, Value>
    extends AbstractMap<Key, Value> {
        private int maxCount = 20;
        private Queue<Entry> queue = new LinkedList<Entry>();

        public PooledMap() {
        }

        public PooledMap(int size) {
            this.maxCount = size;
        }

        @Override
        public Value put(Key key, Value value) {
            while (this.queue.size() >= this.maxCount) {
                this.queue.remove();
            }
            this.queue.add(new Entry(key, value));
            return value;
        }

        @Override
        public Value get(Object key) {
            for (Entry type : this.queue) {
                if (!type.key.equals(key)) continue;
                this.queue.remove(type);
                this.queue.add(type);
                return (Value)type.value;
            }
            return null;
        }

        @Override
        public Set<Map.Entry<Key, Value>> entrySet() {
            HashSet<Map.Entry<Key, Value>> set = new HashSet<Map.Entry<Key, Value>>();
            set.addAll(this.queue);
            return set;
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public Set<Key> keySet() {
            HashSet set = new HashSet();
            for (Entry e : this.queue) {
                set.add(e.getKey());
            }
            return set;
        }

        @Override
        public Value remove(Object obj) {
            try {
                for (Entry e : this.queue) {
                    if (!e.getKey().equals(obj)) continue;
                    Entry tempEntry = null;
                    if (e != null) {
                        tempEntry = e;
                        this.queue.remove(e);
                    }
                    return tempEntry == null ? null : (Value)tempEntry.getValue();
                }
            }
            catch (ConcurrentModificationException mfe) {
                return null;
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Entry
        implements Map.Entry<Key, Value> {
            private Key key;
            private Value value;

            public Entry(Key key, Value value) {
                this.key = key;
                this.value = value;
            }

            public String toString() {
                return this.key + "=" + this.value;
            }

            @Override
            public Key getKey() {
                return this.key;
            }

            @Override
            public Value getValue() {
                return this.value;
            }

            @Override
            public Value setValue(Value value) {
                this.value = value;
                return this.value;
            }
        }
    }
}

