/*
 * Decompiled with CFR 0.152.
 */
package cn.emay.sdk.communication.util;

import cn.emay.sdk.communication.util.Encryption;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.ParseException;
import java.util.StringTokenizer;

public final class SecurityCode {
    public static final String OS_WINDOWS = "windows";
    public static final String OS_LINUX = "linux";
    public static final String OS_SOLARIS = "sunos";
    public static final String OS_AIX = "aix";

    public static final String getSecurityCode() throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        Encryption enc = new Encryption();
        try {
            if (os.startsWith(OS_WINDOWS)) {
                return enc.getEncryptedString(SecurityCode.windowsParseMacAddress(SecurityCode.windowsRunIpConfigCommand()));
            }
            if (os.startsWith(OS_LINUX)) {
                return enc.getEncryptedString(SecurityCode.linuxParseMacAddress(SecurityCode.linuxRunIfConfigCommand()));
            }
            if (os.startsWith(OS_SOLARIS)) {
                return enc.getEncryptedString(SecurityCode.solarisParseMacAddress(SecurityCode.solarisRunIfConfigCommand()));
            }
            if (os.startsWith(OS_AIX)) {
                return enc.getEncryptedString(SecurityCode.aixParseMacAddress(SecurityCode.aixRunIfConfigCommand()));
            }
            throw new IOException("unknown operating system: " + os);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final String linuxParseMacAddress(String ipConfigResponse) throws ParseException {
        block11: {
            localHost = null;
            em = null;
            em1 = null;
            try {
                localHost = InetAddress.getLocalHost().getHostAddress();
                if (localHost.length() > 15) {
                    localHost = SecurityCode.getIpv6(localHost);
                }
                if (localHost.startsWith("127.0.") || localHost.startsWith("0.0.")) {
                    throw new Exception();
                }
                break block11;
            }
            catch (Exception ex) {
                localHost = null;
                try {
                    em = NetworkInterface.getNetworkInterfaces();
                    if (true) ** GOTO lbl26
                }
                catch (Exception e) {
                    throw new ParseException("getNetworkInterfaces() error!(Emay sdk)", 0);
                }
            }
            do {
                ni = em.nextElement();
                em1 = ni.getInetAddresses();
                while (em1.hasMoreElements()) {
                    ia = em1.nextElement();
                    if (ia.isLoopbackAddress() || !ia.isSiteLocalAddress()) continue;
                    localHost = ia.getHostAddress();
                }
lbl26:
                // 2 sources

            } while (em.hasMoreElements());
        }
        if (localHost == null) {
            throw new ParseException("\u8fed\u4ee3\u5168\u90e8ip\u5931\u8d25!", 0);
        }
        tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            line = tokenizer.nextToken().trim();
            v0 = containsLocalHost = line.indexOf(localHost) >= 0;
            if (containsLocalHost && lastMacAddress != null) {
                return lastMacAddress;
            }
            macAddressPosition = line.indexOf("HWaddr");
            if (macAddressPosition < 0 || !SecurityCode.linuxIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        ex = new ParseException("cannot read MAC address for " + localHost + " from [" + ipConfigResponse + "]", 0);
        ex.printStackTrace();
        throw ex;
    }

    private static final boolean linuxIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private static final String linuxRunIfConfigCommand() throws IOException {
        int c;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("ifconfig");
        }
        catch (IOException ioEx) {
            p = Runtime.getRuntime().exec("/sbin/ifconfig");
        }
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    /*
     * Unable to fully structure code
     */
    private static final String windowsParseMacAddress(String ipConfigResponse) throws ParseException {
        block12: {
            localHost = null;
            em = null;
            em1 = null;
            try {
                localHost = InetAddress.getLocalHost().getHostAddress();
                if (localHost.length() > 15) {
                    localHost = SecurityCode.getIpv6(localHost);
                }
                if (localHost.startsWith("127.0.") || localHost.startsWith("0.0.")) {
                    throw new Exception();
                }
                break block12;
            }
            catch (Exception ex) {
                localHost = null;
                try {
                    em = NetworkInterface.getNetworkInterfaces();
                    if (true) ** GOTO lbl28
                }
                catch (Exception e) {
                    throw new ParseException("getNetworkInterfaces() error!(Emay sdk)", 0);
                }
            }
            block4: do {
                ni = em.nextElement();
                em1 = ni.getInetAddresses();
                while (em1.hasMoreElements()) {
                    ia = em1.nextElement();
                    localHost = ia.getHostAddress();
                    if (localHost == null || localHost.startsWith("127.0.") || localHost.startsWith("0.0.")) {
                        localHost = null;
                    }
                    if (localHost != null) continue block4;
                }
lbl28:
                // 3 sources

            } while (em.hasMoreElements());
        }
        if (localHost == null) {
            throw new ParseException("getNetworkInterfaces() error!localHost is null(Emay sdk)", 0);
        }
        tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            line = tokenizer.nextToken().trim();
            if (line.endsWith(localHost) && lastMacAddress != null) {
                return lastMacAddress;
            }
            if (line.indexOf("Physical Address") < 0 || (macAddressPosition = line.indexOf(":")) < 0 || !SecurityCode.windowsIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 1).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        ex = new ParseException("cannot read MAC address from [" + ipConfigResponse + "]", 0);
        ex.printStackTrace();
        throw ex;
    }

    private static final boolean windowsIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private static final String windowsRunIpConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ipconfig /all");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    /*
     * Unable to fully structure code
     */
    private static final String solarisParseMacAddress(String ipConfigResponse) throws ParseException {
        block11: {
            localHost = null;
            em = null;
            em1 = null;
            try {
                localHost = InetAddress.getLocalHost().getHostAddress();
                if (localHost.length() > 15) {
                    localHost = SecurityCode.getIpv6(localHost);
                }
                if (localHost.startsWith("127.0.") || localHost.startsWith("0.0.")) {
                    throw new Exception();
                }
                break block11;
            }
            catch (Exception ex) {
                localHost = null;
                try {
                    em = NetworkInterface.getNetworkInterfaces();
                    if (true) ** GOTO lbl28
                }
                catch (Exception e) {
                    throw new ParseException("getNetworkInterfaces() error!(Emay sdk)", 0);
                }
            }
            block4: do {
                ni = em.nextElement();
                em1 = ni.getInetAddresses();
                while (em1.hasMoreElements()) {
                    ia = em1.nextElement();
                    localHost = ia.getHostAddress();
                    if (localHost == null || localHost.startsWith("127.0.") || localHost.startsWith("0.0.")) {
                        localHost = null;
                    }
                    if (localHost != null) continue block4;
                }
lbl28:
                // 3 sources

            } while (em.hasMoreElements());
        }
        if (localHost == null) {
            throw new ParseException("getNetworkInterfaces() error!localHost is null(Emay sdk)", 0);
        }
        tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        while (tokenizer.hasMoreTokens()) {
            line = tokenizer.nextToken().trim();
            macAddressPosition = line.indexOf("ether");
            if (macAddressPosition < 0 || !SecurityCode.solarisIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            return macAddressCandidate;
        }
        ex = new ParseException("cannot read MAC address for " + localHost + " from [" + localHost + "]", 0);
        ex.printStackTrace();
        throw ex;
    }

    /*
     * Unable to fully structure code
     */
    private static final String aixParseMacAddress(String ipConfigResponse) throws ParseException {
        block11: {
            localHost = null;
            em = null;
            em1 = null;
            try {
                localHost = InetAddress.getLocalHost().getHostAddress();
                if (localHost.length() > 15) {
                    localHost = SecurityCode.getIpv6(localHost);
                }
                if (localHost.startsWith("127.0.") || localHost.startsWith("0.0.")) {
                    throw new Exception();
                }
                break block11;
            }
            catch (Exception ex) {
                localHost = null;
                try {
                    em = NetworkInterface.getNetworkInterfaces();
                    if (true) ** GOTO lbl28
                }
                catch (Exception e) {
                    throw new ParseException("getNetworkInterfaces() error!(Emay sdk)", 0);
                }
            }
            block4: do {
                ni = em.nextElement();
                em1 = ni.getInetAddresses();
                while (em1.hasMoreElements()) {
                    ia = em1.nextElement();
                    localHost = ia.getHostAddress();
                    if (localHost == null || localHost.startsWith("127.0.") || localHost.startsWith("0.0.")) {
                        localHost = null;
                    }
                    if (localHost != null) continue block4;
                }
lbl28:
                // 3 sources

            } while (em.hasMoreElements());
        }
        if (localHost == null) {
            throw new ParseException("getNetworkInterfaces() error!localHost is null(Emay sdk)", 0);
        }
        tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        while (tokenizer.hasMoreTokens()) {
            line = tokenizer.nextToken().trim();
            macAddressPosition = line.indexOf("en0");
            if (macAddressPosition < 0 || !SecurityCode.aixIsMacAddress(macAddressCandidate = line.substring(macAddressPosition + 10, macAddressPosition + 18).trim())) continue;
            return macAddressCandidate;
        }
        ex = new ParseException("cannot read MAC address for " + localHost + " from [" + localHost + "]", 0);
        ex.printStackTrace();
        throw ex;
    }

    private static final boolean aixIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 8;
    }

    private static final boolean solarisIsMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() >= 14 && macAddressCandidate.length() <= 17;
    }

    private static final String solarisRunIfConfigCommand() throws IOException, ParseException {
        int c;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("ifconfig -a");
        }
        catch (IOException ioEx) {
            throw new ParseException("parse solaris Mac address error", 0);
        }
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final String aixRunIfConfigCommand() throws IOException, ParseException {
        int c;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec("ifconfig -a");
        }
        catch (IOException ioEx) {
            throw new ParseException("parse aix Mac address error", 0);
        }
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final String getIpv6(String localHost) {
        StringTokenizer to = new StringTokenizer(localHost, ":");
        String str1 = "";
        String str2 = "";
        String str3 = ":";
        int i = 0;
        boolean j = false;
        while (to.hasMoreTokens()) {
            str1 = to.nextToken().trim();
            if (str1.equals("0") && !j) {
                ++i;
                continue;
            }
            if (i > 1 && !j) {
                str2 = String.valueOf(str2) + str3 + str1 + ":";
                i = 0;
                j = true;
                continue;
            }
            str2 = i == 1 && !j ? String.valueOf(str2) + "0:" + str1 + ":" : String.valueOf(str2) + str1 + ":";
        }
        if ((str2 = str2.substring(0, str2.length() - 1)).substring(0, 1).equals(":")) {
            str2 = ":" + str2;
        }
        localHost = str2;
        return localHost;
    }

    public static final void main(String[] args) {
        try {
            SecurityCode.linuxIsMacAddress(SecurityCode.linuxParseMacAddress(SecurityCode.linuxRunIfConfigCommand()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

