/*
 * Decompiled with CFR 0.152.
 */
package com.jfplugin.mail;

import com.jfinal.render.RenderManager;
import com.jfplugin.mail.core.JavaMailSender;
import com.jfplugin.mail.core.JavaMailSenderImpl;
import com.jfplugin.mail.core.MimeMessageHelper;
import com.jfplugin.mail.exception.MailSendException;
import com.jfplugin.mail.mockhttp.MockHttpServletRequest;
import com.jfplugin.mail.mockhttp.MockHttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MailPro {
    private JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
    private String from = null;

    MailPro(Properties props) {
        this.mailSender.setHost(props.getProperty("host"));
        this.mailSender.setPort(Integer.parseInt(props.getProperty("port")));
        this.mailSender.setUsername(props.getProperty("username"));
        this.mailSender.setPassword(props.getProperty("password"));
        this.mailSender.setProtocol(props.getProperty("protocol", "smtp"));
        this.mailSender.setJavaMailProperties(props);
        this.from = props.getProperty("username");
    }

    public void send(String to, List<String> cc, String subject, String text) {
        this.send(to, cc, subject, text, new ArrayList<File>());
    }

    public void send(String to, List<String> cc, String subject, String text, List<File> attachments) {
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper mimeMessageHelper = null;
            mimeMessageHelper = attachments != null && attachments.size() > 0 ? new MimeMessageHelper(mimeMessage, 1, "UTF-8") : new MimeMessageHelper(mimeMessage, "UTF-8");
            mimeMessageHelper.setTo(to);
            if (cc != null) {
                mimeMessageHelper.setCc(cc.toArray(new String[0]));
            }
            mimeMessageHelper.setSubject(subject);
            mimeMessageHelper.setFrom(this.from);
            mimeMessageHelper.setText(text, true);
            if (attachments != null && attachments.size() > 0) {
                for (File file : attachments) {
                    mimeMessageHelper.addAttachment(file.getName(), file);
                }
            }
            this.mailSender.send(mimeMessage);
        }
        catch (Exception e) {
            throw new MailSendException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01", e);
        }
    }

    public void send(String to, List<String> cc, String subject, String viewPath, Map<String, Object> dataMap) {
        this.send(to, cc, subject, viewPath, dataMap, null);
    }

    public void send(String to, List<String> cc, String subject, String viewPath, Map<String, Object> dataMap, List<File> attachments) {
        HttpServletResponse response = (HttpServletResponse)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletResponse.class}, (InvocationHandler)new MockHttpServletResponse());
        HttpServletRequest request = (HttpServletRequest)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, (InvocationHandler)new MockHttpServletRequest());
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
        RenderManager.me().getRenderFactory().getRender(viewPath).setContext(request, response).render();
        try {
            String text = response.getWriter().toString();
            this.send(to, cc, subject, text, attachments);
        }
        catch (IOException e) {
            throw new MailSendException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01", e);
        }
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }
}

