/*
 * Decompiled with CFR 0.152.
 */
package com.jfplugin.mail.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;

public class ConfigurableMimeFileTypeMap
extends FileTypeMap {
    private String[] mappings;
    private FileTypeMap fileTypeMap;

    public void setMappings(String[] mappings) {
        this.mappings = mappings;
    }

    public void afterPropertiesSet() {
        this.getFileTypeMap();
    }

    protected final FileTypeMap getFileTypeMap() {
        if (this.fileTypeMap == null) {
            String name = "mime.types";
            try {
                this.fileTypeMap = this.createFileTypeMap(((Object)((Object)this)).getClass().getResourceAsStream(name), this.mappings);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not load specified MIME type mapping file: " + name, ex);
            }
        }
        return this.fileTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileTypeMap createFileTypeMap(InputStream is, String[] mappings) throws IOException {
        MimetypesFileTypeMap fileTypeMap = null;
        if (is != null) {
            try {
                fileTypeMap = new MimetypesFileTypeMap(is);
            }
            finally {
                is.close();
            }
        } else {
            fileTypeMap = new MimetypesFileTypeMap();
        }
        if (mappings != null) {
            for (String mapping : mappings) {
                fileTypeMap.addMimeTypes(mapping);
            }
        }
        return fileTypeMap;
    }

    public String getContentType(File file) {
        return this.getFileTypeMap().getContentType(file);
    }

    public String getContentType(String fileName) {
        return this.getFileTypeMap().getContentType(fileName);
    }
}

