/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.enums;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.zhyd.oauth.config.AuthDefaultSource;

@Schema(title="\u8d26\u53f7\u7c7b\u578b")
@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum AccountType {
    INSTITUTION("INSTITUTION", "", "\u673a\u6784\u4eba\u5458"),
    SMS("SMS", "PHONE_NUMBER", "\u624b\u673a\u9a8c\u8bc1\u7801"),
    WXAPP("WXAPP", "WECHAT_MINI_APP", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f"),
    QQ(AuthDefaultSource.QQ.name(), "JUST_AUTH", "QQ"),
    WEIBO(AuthDefaultSource.WEIBO.name(), "JUST_AUTH", "\u5fae\u535a"),
    BAIDU(AuthDefaultSource.BAIDU.name(), "JUST_AUTH", "\u767e\u5ea6"),
    WECHAT_OPEN(AuthDefaultSource.WECHAT_OPEN.name(), "JUST_AUTH", "\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0"),
    WECHAT_MP(AuthDefaultSource.WECHAT_MP.name(), "JUST_AUTH", "\u5fae\u4fe1\u516c\u4f17\u53f7"),
    WECHAT_ENTERPRISE(AuthDefaultSource.WECHAT_ENTERPRISE.name(), "JUST_AUTH", "\u4f01\u4e1a\u5fae\u4fe1\u4e8c\u7ef4\u7801"),
    WECHAT_ENTERPRISE_WEB(AuthDefaultSource.WECHAT_ENTERPRISE_WEB.name(), "JUST_AUTH", "\u4f01\u4e1a\u5fae\u4fe1\u7f51\u9875"),
    DINGTALK(AuthDefaultSource.DINGTALK.name(), "JUST_AUTH", "\u9489\u9489"),
    DINGTALK_ACCOUNT(AuthDefaultSource.DINGTALK_ACCOUNT.name(), "JUST_AUTH", "\u9489\u9489\u8d26\u53f7"),
    ALIYUN(AuthDefaultSource.ALIYUN.name(), "JUST_AUTH", "\u963f\u91cc\u4e91"),
    TAOBAO(AuthDefaultSource.TAOBAO.name(), "JUST_AUTH", "\u6dd8\u5b9d"),
    ALIPAY(AuthDefaultSource.ALIPAY.name(), "JUST_AUTH", "\u652f\u4ed8\u5b9d"),
    TEAMBITION(AuthDefaultSource.TEAMBITION.name(), "JUST_AUTH", "Teambition"),
    HUAWEI(AuthDefaultSource.HUAWEI.name(), "JUST_AUTH", "\u534e\u4e3a"),
    FEISHU(AuthDefaultSource.FEISHU.name(), "JUST_AUTH", "\u98de\u4e66"),
    JD(AuthDefaultSource.JD.name(), "JUST_AUTH", "\u4eac\u4e1c"),
    DOUYIN(AuthDefaultSource.DOUYIN.name(), "JUST_AUTH", "\u6296\u97f3"),
    TOUTIAO(AuthDefaultSource.TOUTIAO.name(), "JUST_AUTH", "\u4eca\u65e5\u5934\u6761"),
    MI(AuthDefaultSource.MI.name(), "JUST_AUTH", "\u5c0f\u7c73"),
    RENREN(AuthDefaultSource.RENREN.name(), "JUST_AUTH", "\u4eba\u4eba"),
    MEITUAN(AuthDefaultSource.MEITUAN.name(), "JUST_AUTH", "\u7f8e\u56e2"),
    ELEME(AuthDefaultSource.ELEME.name(), "JUST_AUTH", "\u997f\u4e86\u4e48"),
    KUJIALE(AuthDefaultSource.KUJIALE.name(), "JUST_AUTH", "\u9177\u5bb6\u4e50"),
    XMLY(AuthDefaultSource.XMLY.name(), "JUST_AUTH", "\u559c\u9a6c\u62c9\u96c5"),
    GITEE(AuthDefaultSource.GITEE.name(), "JUST_AUTH", "\u7801\u4e91"),
    OSCHINA(AuthDefaultSource.OSCHINA.name(), "JUST_AUTH", "\u5f00\u6e90\u4e2d\u56fd"),
    CSDN(AuthDefaultSource.CSDN.name(), "JUST_AUTH", "CSDN"),
    GITHUB(AuthDefaultSource.GITHUB.name(), "JUST_AUTH", "Github"),
    GITLAB(AuthDefaultSource.GITLAB.name(), "JUST_AUTH", "Gitlab"),
    STACK_OVERFLOW(AuthDefaultSource.STACK_OVERFLOW.name(), "JUST_AUTH", "Stackoverflow"),
    CODING(AuthDefaultSource.CODING.name(), "JUST_AUTH", "Coding"),
    GOOGLE(AuthDefaultSource.GOOGLE.name(), "JUST_AUTH", "\u8c37\u6b4c"),
    MICROSOFT(AuthDefaultSource.MICROSOFT.name(), "JUST_AUTH", "\u5fae\u8f6f"),
    FACEBOOK(AuthDefaultSource.FACEBOOK.name(), "JUST_AUTH", "\u8138\u4e66"),
    LINKEDIN(AuthDefaultSource.LINKEDIN.name(), "JUST_AUTH", "\u9886\u82f1"),
    TWITTER(AuthDefaultSource.TWITTER.name(), "JUST_AUTH", "\u63a8\u7279"),
    AMAZON(AuthDefaultSource.AMAZON.name(), "JUST_AUTH", "\u4e9a\u9a6c\u900a"),
    SLACK(AuthDefaultSource.SLACK.name(), "JUST_AUTH", "Slack"),
    LINE(AuthDefaultSource.LINE.name(), "JUST_AUTH", "Line"),
    OKTA(AuthDefaultSource.OKTA.name(), "JUST_AUTH", "Okta"),
    PINTEREST(AuthDefaultSource.PINTEREST.name(), "JUST_AUTH", "Pinterest");

    @Schema(title="\u679a\u4e3e\u503c")
    private final String key;
    @Schema(title="\u5904\u7406\u5668")
    private final String handler;
    @Schema(title="\u6587\u5b57")
    private final String description;
    private static final Map<String, AccountType> INDEX_MAP;
    private static final List<Map<String, Object>> JSON_STRUCT;
    public static final String JUST_AUTH_HANDLER = "JUST_AUTH";
    public static final String PHONE_NUMBER_HANDLER = "PHONE_NUMBER";
    public static final String WECHAT_MINI_APP_HANDLER = "WECHAT_MINI_APP";

    private AccountType(String key, String handler, String description) {
        this.key = key;
        this.handler = handler;
        this.description = description;
    }

    @JsonValue
    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHandler() {
        return this.handler;
    }

    public static AccountType getAccountType(String key) {
        return INDEX_MAP.get(key);
    }

    public static List<Map<String, Object>> getJsonStruct() {
        return JSON_STRUCT;
    }

    static {
        INDEX_MAP = new HashMap<String, AccountType>();
        JSON_STRUCT = new ArrayList<Map<String, Object>>();
        for (AccountType accountType : AccountType.values()) {
            INDEX_MAP.put(accountType.getKey(), accountType);
            JSON_STRUCT.add(accountType.ordinal(), (Map<String, Object>)ImmutableMap.builder().put((Object)"value", (Object)accountType.ordinal()).put((Object)"key", (Object)accountType.name()).put((Object)"text", (Object)accountType.getDescription()).build());
        }
    }
}

