/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.exception;

import cn.herodotus.engine.assistant.core.definition.exception.HerodotusException;
import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.assistant.core.enums.ResultErrorCodes;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final Map<String, Result<String>> EXCEPTION_DICTIONARY = new HashMap<String, Result<String>>();

    protected static Result<String> getResult(ResultErrorCodes resultErrorCodes, int httpStatus) {
        return Result.failure(resultErrorCodes.getMessage(), resultErrorCodes.getCode(), httpStatus, null);
    }

    public static Result<String> getUnauthorizedResult(ResultErrorCodes resultCode) {
        return GlobalExceptionHandler.getResult(resultCode, 401);
    }

    public static Result<String> getForbiddenResult(ResultErrorCodes resultCode) {
        return GlobalExceptionHandler.getResult(resultCode, 403);
    }

    public static Result<String> getNotAcceptableResult(ResultErrorCodes resultCode) {
        return GlobalExceptionHandler.getResult(resultCode, 406);
    }

    public static Result<String> getPreconditionFailedResult(ResultErrorCodes resultCode) {
        return GlobalExceptionHandler.getResult(resultCode, 412);
    }

    private static Result<String> getUnsupportedMediaTypeResult(ResultErrorCodes resultCode) {
        return GlobalExceptionHandler.getResult(resultCode, 415);
    }

    public static Result<String> getInternalServerErrorResult(ResultErrorCodes resultCode) {
        return GlobalExceptionHandler.getResult(resultCode, 500);
    }

    public static Result<String> getServiceUnavailableResult(ResultErrorCodes resultCode) {
        return GlobalExceptionHandler.getResult(resultCode, 503);
    }

    public static Result<String> resolveException(Exception ex, String path) {
        log.trace("[Herodotus] |- Global Exception Handler, Path : [{}], Exception : [{}]", (Object)path, (Object)ex);
        if (ex instanceof HerodotusException) {
            HerodotusException exception = (HerodotusException)((Object)ex);
            Result<String> result = exception.getResult();
            result.path(path);
            return result;
        }
        Result<Object> result = Result.failure();
        String exceptionName = ex.getClass().getSimpleName();
        if (StringUtils.isNotEmpty((CharSequence)exceptionName) && EXCEPTION_DICTIONARY.containsKey(exceptionName)) {
            result = EXCEPTION_DICTIONARY.get(exceptionName);
        } else {
            log.warn("[Herodotus] |- Global Exception Handler,  Can not find the exception name [{}] in dictionary, please do optimize ", (Object)exceptionName);
        }
        result.path(path);
        result.stackTrace(ex.getStackTrace());
        result.detail(ex.getMessage());
        log.debug("[Herodotus] |- Global Exception Handler, Error is : {}", result);
        return result;
    }

    static {
        EXCEPTION_DICTIONARY.put("AccessDeniedException", GlobalExceptionHandler.getUnauthorizedResult(ResultErrorCodes.ACCESS_DENIED));
        EXCEPTION_DICTIONARY.put("InsufficientAuthenticationException", GlobalExceptionHandler.getUnauthorizedResult(ResultErrorCodes.ACCESS_DENIED));
        EXCEPTION_DICTIONARY.put("HttpRequestMethodNotSupportedException", GlobalExceptionHandler.getResult(ResultErrorCodes.HTTP_REQUEST_METHOD_NOT_SUPPORTED, 405));
        EXCEPTION_DICTIONARY.put("HttpMediaTypeNotAcceptableException", GlobalExceptionHandler.getUnsupportedMediaTypeResult(ResultErrorCodes.HTTP_MEDIA_TYPE_NOT_ACCEPTABLE));
        EXCEPTION_DICTIONARY.put("IllegalArgumentException", GlobalExceptionHandler.getInternalServerErrorResult(ResultErrorCodes.ILLEGAL_ARGUMENT_EXCEPTION));
        EXCEPTION_DICTIONARY.put("NullPointerException", GlobalExceptionHandler.getInternalServerErrorResult(ResultErrorCodes.NULL_POINTER_EXCEPTION));
        EXCEPTION_DICTIONARY.put("IOException", GlobalExceptionHandler.getInternalServerErrorResult(ResultErrorCodes.IO_EXCEPTION));
        EXCEPTION_DICTIONARY.put("HttpMessageNotReadableException", GlobalExceptionHandler.getInternalServerErrorResult(ResultErrorCodes.HTTP_MESSAGE_NOT_READABLE_EXCEPTION));
        EXCEPTION_DICTIONARY.put("TypeMismatchException", GlobalExceptionHandler.getInternalServerErrorResult(ResultErrorCodes.TYPE_MISMATCH_EXCEPTION));
        EXCEPTION_DICTIONARY.put("MissingServletRequestParameterException", GlobalExceptionHandler.getInternalServerErrorResult(ResultErrorCodes.MISSING_SERVLET_REQUEST_PARAMETER_EXCEPTION));
        EXCEPTION_DICTIONARY.put("ProviderNotFoundException", GlobalExceptionHandler.getServiceUnavailableResult(ResultErrorCodes.PROVIDER_NOT_FOUND));
        EXCEPTION_DICTIONARY.put("CookieTheftException", GlobalExceptionHandler.getServiceUnavailableResult(ResultErrorCodes.COOKIE_THEFT));
        EXCEPTION_DICTIONARY.put("InvalidCookieException", GlobalExceptionHandler.getServiceUnavailableResult(ResultErrorCodes.INVALID_COOKIE));
        EXCEPTION_DICTIONARY.put("BadSqlGrammarException", GlobalExceptionHandler.getInternalServerErrorResult(ResultErrorCodes.BAD_SQL_GRAMMAR));
        EXCEPTION_DICTIONARY.put("DataIntegrityViolationException", GlobalExceptionHandler.getInternalServerErrorResult(ResultErrorCodes.DATA_INTEGRITY_VIOLATION));
        EXCEPTION_DICTIONARY.put("TransactionRollbackException", GlobalExceptionHandler.getInternalServerErrorResult(ResultErrorCodes.TRANSACTION_ROLLBACK));
        EXCEPTION_DICTIONARY.put("BindException", GlobalExceptionHandler.getNotAcceptableResult(ResultErrorCodes.METHOD_ARGUMENT_NOT_VALID));
        EXCEPTION_DICTIONARY.put("MethodArgumentNotValidException", GlobalExceptionHandler.getNotAcceptableResult(ResultErrorCodes.METHOD_ARGUMENT_NOT_VALID));
        EXCEPTION_DICTIONARY.put("RedisPipelineException", GlobalExceptionHandler.getResult(ResultErrorCodes.PIPELINE_INVALID_COMMANDS, 500));
    }
}

