/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.json.jackson2.deserializer;

import cn.herodotus.engine.assistant.core.utils.XssUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssStringJsonDeserializer
extends JsonDeserializer<String> {
    private static final Logger log = LoggerFactory.getLogger(XssStringJsonDeserializer.class);

    public Class<String> handledType() {
        return String.class;
    }

    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String value = jsonParser.getValueAsString();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return XssUtils.cleaning(value);
        }
        return value;
    }
}

