/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.utils;

import cn.herodotus.engine.assistant.core.enums.Protocol;
import org.apache.commons.lang3.StringUtils;

public class ConvertUtils {
    public static String wellFormed(String url) {
        if (StringUtils.endsWith((CharSequence)url, (CharSequence)"/")) {
            return url;
        }
        return url + "/";
    }

    public static String addressToUri(String address, Protocol protocol, boolean endWithForwardSlash) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtils.startsWith((CharSequence)address, (CharSequence)protocol.getFormat())) {
            stringBuilder.append(protocol.getFormat());
        }
        if (endWithForwardSlash) {
            stringBuilder.append(ConvertUtils.wellFormed(address));
        } else {
            stringBuilder.append(address);
        }
        return stringBuilder.toString();
    }

    public static String addressToUri(String address, boolean endWithForwardSlash) {
        return ConvertUtils.addressToUri(address, Protocol.HTTP, endWithForwardSlash);
    }

    public static String addressToUri(String address) {
        return ConvertUtils.addressToUri(address, false);
    }
}

