/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.c3p0;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.dialect.DriverUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.setting.Setting;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class C3p0DSFactory
extends DSFactory {
    public static final String DS_NAME = "C3P0";
    private Map<String, ComboPooledDataSource> dsMap = new ConcurrentHashMap<String, ComboPooledDataSource>();

    public C3p0DSFactory() {
        this(null);
    }

    public C3p0DSFactory(Setting setting) {
        super(DS_NAME, ComboPooledDataSource.class, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        ComboPooledDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        ComboPooledDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        ComboPooledDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            ds.close();
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<ComboPooledDataSource> values = this.dsMap.values();
            for (ComboPooledDataSource ds : values) {
                ds.close();
            }
            this.dsMap.clear();
        }
    }

    private ComboPooledDataSource createDataSource(String group) {
        Setting config = this.setting.getSetting(group);
        if (CollectionUtil.isEmpty(config)) {
            throw new DbRuntimeException("No C3P0 config for group: [{}]", group);
        }
        ComboPooledDataSource ds = new ComboPooledDataSource();
        String url = config.getAndRemoveStr(KEY_ALIAS_URL);
        if (StrUtil.isBlank(url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        ds.setJdbcUrl(url);
        ds.setUser(config.getAndRemoveStr(KEY_ALIAS_USER));
        ds.setPassword(config.getAndRemoveStr(KEY_ALIAS_PASSWORD));
        String driver = config.getAndRemoveStr(KEY_ALIAS_DRIVER);
        try {
            if (StrUtil.isNotBlank(driver)) {
                ds.setDriverClass(driver);
            } else {
                ds.setDriverClass(DriverUtil.identifyDriver(url));
            }
        }
        catch (Exception e) {
            throw new DbRuntimeException(e);
        }
        config.toBean(ds);
        return ds;
    }
}

