/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.simple;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.dialect.DriverUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.ds.simple.AbstractDataSource;
import cn.hutool.setting.Setting;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SimpleDataSource
extends AbstractDataSource {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private String driver;
    private String url;
    private String user;
    private String pass;

    public static synchronized SimpleDataSource getDataSource(String group) {
        return new SimpleDataSource(group);
    }

    public static synchronized SimpleDataSource getDataSource() {
        return new SimpleDataSource();
    }

    public SimpleDataSource() {
        this(null);
    }

    public SimpleDataSource(String group) {
        this(null, group);
    }

    public SimpleDataSource(Setting setting, String group) {
        Setting config;
        if (null == setting) {
            setting = new Setting(DEFAULT_DB_CONFIG_PATH);
        }
        if (CollectionUtil.isEmpty(config = setting.getSetting(group))) {
            throw new DbRuntimeException("No C3P0 config for group: [{}]", group);
        }
        this.init(config.getAndRemoveStr(DSFactory.KEY_ALIAS_URL), config.getAndRemoveStr(DSFactory.KEY_ALIAS_USER), config.getAndRemoveStr(DSFactory.KEY_ALIAS_PASSWORD), config.getAndRemoveStr(DSFactory.KEY_ALIAS_DRIVER));
    }

    public SimpleDataSource(String url, String user, String pass) {
        this.init(url, user, pass);
    }

    public SimpleDataSource(String url, String user, String pass, String driver) {
        this.init(url, user, pass, driver);
    }

    public void init(String url, String user, String pass) {
        this.init(url, user, pass, null);
    }

    public void init(String url, String user, String pass, String driver) {
        this.driver = StrUtil.isBlank(driver) ? DriverUtil.identifyDriver(url) : driver;
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new DbRuntimeException(e, "Get jdbc driver [{}] error!", driver);
        }
        this.url = url;
        this.user = user;
        this.pass = pass;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.user, this.pass);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return DriverManager.getConnection(this.url, username, password);
    }

    @Override
    public void close() throws IOException {
    }
}

