/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import java.util.HashMap;
import java.util.Map;

public abstract class CustomKeyMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 4043263744224569870L;

    public CustomKeyMap() {
    }

    public CustomKeyMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CustomKeyMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CustomKeyMap(Map<? extends K, ? extends V> m) {
        super((int)((double)m.size() / 0.75));
        this.putAll(m);
    }

    public CustomKeyMap(float loadFactor, Map<? extends K, ? extends V> m) {
        super(m.size(), loadFactor);
        this.putAll(m);
    }

    @Override
    public V get(Object key) {
        return super.get(this.customKey(key));
    }

    @Override
    public V put(K key, V value) {
        return super.put(this.customKey(key), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.customKey(key));
    }

    protected abstract Object customKey(Object var1);
}

