/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.webservice;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class SoapRequest {
    public static final String XMLNS_SOAPENV = "soapenv";
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml;charset=";
    private static final Pattern SOAP_BODY_PATTERN = Pattern.compile("<soap:Body>(.*?)</soap:Body>", 32);
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private String url;
    private String methodNamespace;
    private String xmlns = "soapenv";
    private String method;
    private Map<String, String> params;

    public SoapRequest(String url, String methodNamespace) {
        this.url = url;
        this.methodNamespace = methodNamespace;
    }

    public SoapRequest setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public SoapRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public SoapRequest setMethodNamespace(String namespace) {
        this.methodNamespace = namespace;
        return this;
    }

    public SoapRequest setXmlns(String xmlns) {
        this.xmlns = xmlns;
        return this;
    }

    public SoapRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public SoapRequest setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public SoapRequest addParam(String name, String value) {
        Map<String, String> params = this.params;
        if (null == params) {
            this.params = params = new LinkedHashMap<String, String>();
        }
        params.put(name, value);
        return this;
    }

    public String execute() {
        return HttpRequest.post(this.url).body(this.toSoapXml()).contentType(this.getXmlContentType()).execute().body();
    }

    public String executeBody() {
        return ReUtil.getGroup1(SOAP_BODY_PATTERN, (CharSequence)this.execute());
    }

    private String toSoapXml() {
        StringBuilder sb = StrUtil.builder();
        sb.append(StrUtil.format((CharSequence)"<{}:Envelope xmlns:{}=\"http://schemas.xmlsoap.org/soap/envelope/\">\n", this.xmlns, this.xmlns));
        sb.append(StrUtil.format((CharSequence)"  <{}:Body>\n", this.xmlns));
        Assert.notBlank(this.method, "Method must be not blank !", new Object[0]);
        sb.append("    <").append(this.method).append(" xmlns=\"").append(this.methodNamespace).append("\">\n");
        if (null != this.params) {
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                sb.append("      <").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">\n");
            }
        }
        sb.append("    </").append(this.method).append(">\n");
        sb.append(StrUtil.format((CharSequence)"  </{}:Body>\n", this.xmlns));
        sb.append(StrUtil.format((CharSequence)"</{}:Envelope>", this.xmlns));
        return sb.toString();
    }

    private String getXmlContentType() {
        return TEXT_XML_CONTENT_TYPE.concat(this.charset.toString());
    }
}

