/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest.mac;

import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.mac.MacEngine;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DefaultHMacEngine
implements MacEngine {
    private Mac mac;

    public DefaultHMacEngine(String algorithm, byte[] key) {
        this.init(algorithm, key);
    }

    public DefaultHMacEngine(String algorithm, SecretKey key) {
        this.init(algorithm, key);
    }

    public DefaultHMacEngine init(String algorithm, byte[] key) {
        return this.init(algorithm, null == key ? null : new SecretKeySpec(key, algorithm));
    }

    public DefaultHMacEngine init(String algorithm, SecretKey key) {
        try {
            this.mac = SecureUtil.createMac(algorithm);
            if (null == key) {
                key = SecureUtil.generateKey(algorithm);
            }
            this.mac.init(key);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return this;
    }

    @Override
    public byte[] digest(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 2048;
        }
        byte[] buffer = new byte[bufferLength];
        byte[] result = null;
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.mac.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = this.mac.doFinal();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public Mac getMac() {
        return this.mac;
    }
}

