/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.LineHandler;
import cn.hutool.core.io.NullOutputStream;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;

public class IoUtil {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIDDLE_BUFFER_SIZE = 16384;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 32768;
    public static final int EOF = -1;

    public static long copy(Reader reader, Writer writer) throws IORuntimeException {
        return IoUtil.copy(reader, writer, 8192);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws IORuntimeException {
        return IoUtil.copy(reader, writer, bufferSize, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        char[] buffer = new char[bufferSize];
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            int readSize;
            while ((readSize = reader.read(buffer, 0, bufferSize)) != -1) {
                writer.write(buffer, 0, readSize);
                size += (long)readSize;
                writer.flush();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
        }
        catch (Exception e) {
            throw new IORuntimeException(e);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copy(InputStream in, OutputStream out) throws IORuntimeException {
        return IoUtil.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IORuntimeException {
        return IoUtil.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        Assert.notNull(out, "OutputStream is null !", new Object[0]);
        if (bufferSize <= 0) {
            bufferSize = 8192;
        }
        byte[] buffer = new byte[bufferSize];
        if (null != streamProgress) {
            streamProgress.start();
        }
        long size = 0L;
        try {
            int readSize;
            while ((readSize = in.read(buffer)) != -1) {
                out.write(buffer, 0, readSize);
                size += (long)readSize;
                out.flush();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return IoUtil.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, streamProgress);
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws IORuntimeException {
        Assert.notNull(in, "FileInputStream is null!", new Object[0]);
        Assert.notNull(out, "FileOutputStream is null!", new Object[0]);
        FileChannel inChannel = in.getChannel();
        FileChannel outChannel = out.getChannel();
        try {
            return inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out) throws IORuntimeException {
        return IoUtil.copy(in, out, 8192);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize) throws IORuntimeException {
        return IoUtil.copy(in, out, bufferSize, null);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        Assert.notNull(out, "OutputStream is null !", new Object[0]);
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize <= 0 ? 8192 : bufferSize);
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            while (in.read(byteBuffer) != -1) {
                byteBuffer.flip();
                size += (long)out.write(byteBuffer);
                byteBuffer.clear();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static BufferedReader getReader(InputStream in, String charsetName) {
        return IoUtil.getReader(in, Charset.forName(charsetName));
    }

    public static BufferedReader getReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static BufferedReader getReader(Reader reader) {
        if (null == reader) {
            return null;
        }
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static PushbackReader getPushBackReader(Reader reader, int pushBackSize) {
        return reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, pushBackSize);
    }

    public static OutputStreamWriter getWriter(OutputStream out, String charsetName) {
        return IoUtil.getWriter(out, Charset.forName(charsetName));
    }

    public static OutputStreamWriter getWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String read(InputStream in, String charsetName) throws IORuntimeException {
        FastByteArrayOutputStream out = IoUtil.read(in);
        return StrUtil.isBlank(charsetName) ? out.toString() : out.toString(charsetName);
    }

    public static String read(InputStream in, Charset charset) throws IORuntimeException {
        FastByteArrayOutputStream out = IoUtil.read(in);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static String read(ReadableByteChannel channel, Charset charset) throws IORuntimeException {
        FastByteArrayOutputStream out = IoUtil.read(channel);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static FastByteArrayOutputStream read(InputStream in) throws IORuntimeException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoUtil.copy(in, out);
        return out;
    }

    public static FastByteArrayOutputStream read(ReadableByteChannel channel) throws IORuntimeException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoUtil.copy(channel, Channels.newChannel(out));
        return out;
    }

    public static String read(Reader reader) throws IORuntimeException {
        StringBuilder builder = StrUtil.builder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(buffer)) {
                builder.append(buffer.flip().toString());
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return builder.toString();
    }

    public static String readUtf8(FileChannel fileChannel) throws IORuntimeException {
        return IoUtil.read(fileChannel, CharsetUtil.CHARSET_UTF_8);
    }

    public static String read(FileChannel fileChannel, String charsetName) throws IORuntimeException {
        return IoUtil.read(fileChannel, CharsetUtil.charset(charsetName));
    }

    public static String read(FileChannel fileChannel, Charset charset) throws IORuntimeException {
        MappedByteBuffer buffer;
        try {
            buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return StrUtil.str((ByteBuffer)buffer, charset);
    }

    public static byte[] readBytes(InputStream in) throws IORuntimeException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoUtil.copy(in, out);
        return out.toByteArray();
    }

    public static byte[] readBytes(InputStream in, int length) throws IORuntimeException {
        int readLength;
        if (null == in) {
            return null;
        }
        if (length <= 0) {
            return new byte[0];
        }
        byte[] b = new byte[length];
        try {
            readLength = in.read(b);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (readLength > 0 && readLength < length) {
            byte[] b2 = new byte[length];
            System.arraycopy(b, 0, b2, 0, readLength);
            return b2;
        }
        return b;
    }

    public static String readHex(InputStream in, int length, boolean toLowerCase) throws IORuntimeException {
        return HexUtil.encodeHexStr(IoUtil.readBytes(in, length), toLowerCase);
    }

    public static String readHex28Upper(InputStream in) throws IORuntimeException {
        return IoUtil.readHex(in, 28, false);
    }

    public static String readHex28Lower(InputStream in) throws IORuntimeException {
        return IoUtil.readHex(in, 28, true);
    }

    public static <T> T readObj(InputStream in) throws IORuntimeException, UtilException {
        if (in == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            Object obj = ois.readObject();
            return (T)obj;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e);
        }
    }

    public static <T extends Collection<String>> T readUtf8Lines(InputStream in, T collection) throws IORuntimeException {
        return IoUtil.readLines(in, CharsetUtil.CHARSET_UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, String charsetName, T collection) throws IORuntimeException {
        return IoUtil.readLines(in, CharsetUtil.charset(charsetName), collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, Charset charset, T collection) throws IORuntimeException {
        return IoUtil.readLines((Reader)IoUtil.getReader(in, charset), collection);
    }

    public static <T extends Collection<String>> T readLines(Reader reader, final T collection) throws IORuntimeException {
        IoUtil.readLines(reader, new LineHandler(){

            @Override
            public void handle(String line) {
                collection.add(line);
            }
        });
        return collection;
    }

    public static void readUtf8Lines(InputStream in, LineHandler lineHandler) throws IORuntimeException {
        IoUtil.readLines(in, CharsetUtil.CHARSET_UTF_8, lineHandler);
    }

    public static void readLines(InputStream in, Charset charset, LineHandler lineHandler) throws IORuntimeException {
        IoUtil.readLines((Reader)IoUtil.getReader(in, charset), lineHandler);
    }

    public static void readLines(Reader reader, LineHandler lineHandler) throws IORuntimeException {
        Assert.notNull(reader);
        Assert.notNull(lineHandler);
        BufferedReader bReader = IoUtil.getReader(reader);
        try {
            String line;
            while ((line = bReader.readLine()) != null) {
                lineHandler.handle(line);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ByteArrayInputStream toStream(String content, String charsetName) {
        return IoUtil.toStream(content, CharsetUtil.charset(charsetName));
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return IoUtil.toStream(StrUtil.bytes((CharSequence)content, charset));
    }

    public static ByteArrayInputStream toUtf8Stream(String content) {
        return IoUtil.toStream(content, CharsetUtil.CHARSET_UTF_8);
    }

    public static ByteArrayInputStream toStream(byte[] content) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content);
    }

    public static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedOutputStream toBuffered(OutputStream out) {
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static InputStream toMarkSupportStream(InputStream in) {
        if (null == in) {
            return null;
        }
        if (!in.markSupported()) {
            return new BufferedInputStream(in);
        }
        return in;
    }

    public static PushbackInputStream toPushbackStream(InputStream in, int pushBackSize) {
        return in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, pushBackSize);
    }

    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws IORuntimeException {
        try {
            out.write(content);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (isCloseOut) {
                IoUtil.close(out);
            }
        }
    }

    public static void writeUtf8(OutputStream out, boolean isCloseOut, Object ... contents) throws IORuntimeException {
        IoUtil.write(out, CharsetUtil.CHARSET_UTF_8, isCloseOut, contents);
    }

    public static void write(OutputStream out, String charsetName, boolean isCloseOut, Object ... contents) throws IORuntimeException {
        IoUtil.write(out, CharsetUtil.charset(charsetName), isCloseOut, contents);
    }

    public static void write(OutputStream out, Charset charset, boolean isCloseOut, Object ... contents) throws IORuntimeException {
        OutputStreamWriter osw = null;
        try {
            osw = IoUtil.getWriter(out, charset);
            for (Object content : contents) {
                if (content == null) continue;
                osw.write(Convert.toStr(content, ""));
                osw.flush();
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (isCloseOut) {
                IoUtil.close(osw);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjects(OutputStream out, boolean isCloseOut, Serializable ... contents) throws IORuntimeException {
        ObjectOutputStream osw = null;
        try {
            osw = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
            for (Serializable content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
                osw.flush();
            }
            if (!isCloseOut) return;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IoUtil.close(osw);
                throw throwable;
            }
        }
        IoUtil.close(osw);
        return;
    }

    public static void flush(Flushable flushable) {
        if (null != flushable) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeIfPosible(Object obj) {
        if (obj instanceof AutoCloseable) {
            IoUtil.close((AutoCloseable)obj);
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IORuntimeException {
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        try {
            int ch2;
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            return ch2 == -1;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IORuntimeException {
        input1 = IoUtil.getReader(input1);
        input2 = IoUtil.getReader(input2);
        try {
            int ch2;
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            return ch2 == -1;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws IORuntimeException {
        BufferedReader br1 = IoUtil.getReader(input1);
        BufferedReader br2 = IoUtil.getReader(input2);
        try {
            String line1 = br1.readLine();
            String line2 = br2.readLine();
            while (line1 != null && line1.equals(line2)) {
                line1 = br1.readLine();
                line2 = br2.readLine();
            }
            return Objects.equals(line1, line2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static long checksumCRC32(InputStream in) throws IORuntimeException {
        return IoUtil.checksum(in, new CRC32()).getValue();
    }

    public static Checksum checksum(InputStream in, Checksum checksum) throws IORuntimeException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        if (null == checksum) {
            checksum = new CRC32();
        }
        try {
            in = new CheckedInputStream(in, checksum);
            IoUtil.copy(in, new NullOutputStream());
        }
        finally {
            IoUtil.close(in);
        }
        return checksum;
    }
}

