/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.qrcode;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.img.Img;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.extra.qrcode.BufferedImageLuminanceSource;
import cn.hutool.extra.qrcode.QrCodeException;
import cn.hutool.extra.qrcode.QrConfig;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class QrCodeUtil {
    public static String generateAsBase64(String content, QrConfig qrConfig, String imageType, String logoBase64) {
        return QrCodeUtil.generateAsBase64(content, qrConfig, imageType, Base64.decode(logoBase64));
    }

    public static String generateAsBase64(String content, QrConfig qrConfig, String imageType, byte[] logo) {
        return QrCodeUtil.generateAsBase64(content, qrConfig, imageType, ImgUtil.toImage(logo));
    }

    public static String generateAsBase64(String content, QrConfig qrConfig, String imageType, Image logo) {
        qrConfig.setImg(logo);
        return QrCodeUtil.generateAsBase64(content, qrConfig, imageType);
    }

    public static String generateAsBase64(String content, QrConfig qrConfig, String imageType) {
        BufferedImage img = QrCodeUtil.generate(content, qrConfig);
        return ImgUtil.toBase64DateUri(img, imageType);
    }

    public static byte[] generatePng(String content, int width, int height) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeUtil.generate(content, width, height, "png", out);
        return out.toByteArray();
    }

    public static byte[] generatePng(String content, QrConfig config) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeUtil.generate(content, config, "png", out);
        return out.toByteArray();
    }

    public static File generate(String content, int width, int height, File targetFile) {
        BufferedImage image = QrCodeUtil.generate(content, width, height);
        ImgUtil.write(image, targetFile);
        return targetFile;
    }

    public static File generate(String content, QrConfig config, File targetFile) {
        BufferedImage image = QrCodeUtil.generate(content, config);
        ImgUtil.write(image, targetFile);
        return targetFile;
    }

    public static void generate(String content, int width, int height, String imageType, OutputStream out) {
        BufferedImage image = QrCodeUtil.generate(content, width, height);
        ImgUtil.write((Image)image, imageType, out);
    }

    public static void generate(String content, QrConfig config, String imageType, OutputStream out) {
        BufferedImage image = QrCodeUtil.generate(content, config);
        ImgUtil.write((Image)image, imageType, out);
    }

    public static BufferedImage generate(String content, int width, int height) {
        return QrCodeUtil.generate(content, new QrConfig(width, height));
    }

    public static BufferedImage generate(String content, BarcodeFormat format, int width, int height) {
        return QrCodeUtil.generate(content, format, new QrConfig(width, height));
    }

    public static BufferedImage generate(String content, QrConfig config) {
        return QrCodeUtil.generate(content, BarcodeFormat.QR_CODE, config);
    }

    public static BufferedImage generate(String content, BarcodeFormat format, QrConfig config) {
        BitMatrix bitMatrix = QrCodeUtil.encode(content, format, config);
        BufferedImage image = QrCodeUtil.toImage(bitMatrix, config.foreColor, config.backColor);
        Image logoImg = config.img;
        if (null != logoImg && BarcodeFormat.QR_CODE == format) {
            int height;
            int width;
            int qrHeight;
            int qrWidth = image.getWidth();
            if (qrWidth < (qrHeight = image.getHeight())) {
                width = qrWidth / config.ratio;
                height = logoImg.getHeight(null) * width / logoImg.getWidth(null);
            } else {
                height = qrHeight / config.ratio;
                width = logoImg.getWidth(null) * height / logoImg.getHeight(null);
            }
            Img.from(image).pressImage(Img.from(logoImg).round(0.3).getImg(), new Rectangle(width, height), 1.0f);
        }
        return image;
    }

    public static BitMatrix encode(String content, int width, int height) {
        return QrCodeUtil.encode(content, BarcodeFormat.QR_CODE, width, height);
    }

    public static BitMatrix encode(String content, QrConfig config) {
        return QrCodeUtil.encode(content, BarcodeFormat.QR_CODE, config);
    }

    public static BitMatrix encode(String content, BarcodeFormat format, int width, int height) {
        return QrCodeUtil.encode(content, format, new QrConfig(width, height));
    }

    public static BitMatrix encode(String content, BarcodeFormat format, QrConfig config) {
        BitMatrix bitMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        if (null == config) {
            config = new QrConfig();
        }
        try {
            bitMatrix = multiFormatWriter.encode(content, format, config.width, config.height, config.toHints());
        }
        catch (WriterException e) {
            throw new QrCodeException(e);
        }
        return bitMatrix;
    }

    public static String decode(InputStream qrCodeInputstream) {
        return QrCodeUtil.decode(ImgUtil.read(qrCodeInputstream));
    }

    public static String decode(File qrCodeFile) {
        return QrCodeUtil.decode(ImgUtil.read(qrCodeFile));
    }

    public static String decode(Image image) {
        return QrCodeUtil.decode(image, true, false);
    }

    public static String decode(Image image, boolean isTryHarder, boolean isPureBarcode) {
        Result result;
        MultiFormatReader formatReader = new MultiFormatReader();
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(ImgUtil.toBufferedImage(image));
        HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(DecodeHintType.TRY_HARDER, isTryHarder);
        hints.put(DecodeHintType.PURE_BARCODE, isPureBarcode);
        try {
            result = formatReader.decode(binaryBitmap, hints);
        }
        catch (NotFoundException e) {
            hints.remove(DecodeHintType.PURE_BARCODE);
            try {
                result = formatReader.decode(binaryBitmap, hints);
            }
            catch (NotFoundException e1) {
                throw new QrCodeException(e1);
            }
        }
        return result.getText();
    }

    public static BufferedImage toImage(BitMatrix matrix, int foreColor, Integer backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, null == backColor ? 2 : 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    image.setRGB(x, y, foreColor);
                    continue;
                }
                if (null == backColor) continue;
                image.setRGB(x, y, backColor);
            }
        }
        return image;
    }
}

