/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class CacheObj<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final K key;
    protected final V obj;
    private volatile long lastAccess;
    protected AtomicLong accessCount = new AtomicLong();
    private final long ttl;

    protected CacheObj(K key, V obj, long ttl) {
        this.key = key;
        this.obj = obj;
        this.ttl = ttl;
        this.lastAccess = System.currentTimeMillis();
    }

    boolean isExpired() {
        if (this.ttl > 0L) {
            long expiredTime = this.lastAccess + this.ttl;
            return expiredTime > 0L && expiredTime < System.currentTimeMillis();
        }
        return false;
    }

    V get(boolean isUpdateLastAccess) {
        if (isUpdateLastAccess) {
            this.lastAccess = System.currentTimeMillis();
        }
        this.accessCount.getAndIncrement();
        return this.obj;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.obj;
    }

    public String toString() {
        return "CacheObj [key=" + this.key + ", obj=" + this.obj + ", lastAccess=" + this.lastAccess + ", accessCount=" + this.accessCount + ", ttl=" + this.ttl + "]";
    }
}

