/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation.scanner;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.scanner.AnnotationScanner;
import cn.hutool.core.collection.CollStreamUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MetaAnnotationScanner
implements AnnotationScanner {
    private final boolean includeSupperMetaAnnotation;

    public MetaAnnotationScanner(boolean includeSupperMetaAnnotation) {
        this.includeSupperMetaAnnotation = includeSupperMetaAnnotation;
    }

    public MetaAnnotationScanner() {
        this(true);
    }

    @Override
    public boolean support(AnnotatedElement annotatedElement) {
        return annotatedElement instanceof Class && ClassUtil.isAssignable(Annotation.class, (Class)annotatedElement);
    }

    public void scan(BiConsumer<Integer, Annotation> consumer, Class<? extends Annotation> source, Predicate<Annotation> filter) {
        filter = ObjectUtil.defaultIfNull(filter, t -> true);
        LinkedList<List> deque = CollUtil.newLinkedList(CollUtil.newArrayList(source));
        int distance = 0;
        do {
            List annotationTypes = (List)deque.removeFirst();
            for (Class type : annotationTypes) {
                List metaAnnotations = Stream.of(type.getAnnotations()).filter(a -> !AnnotationUtil.isJdkMetaAnnotation(a.annotationType())).filter(filter).collect(Collectors.toList());
                for (Annotation metaAnnotation : metaAnnotations) {
                    consumer.accept(distance, metaAnnotation);
                }
                deque.addLast(CollStreamUtil.toList(metaAnnotations, Annotation::annotationType));
            }
            ++distance;
        } while (this.includeSupperMetaAnnotation && !deque.isEmpty());
    }

    @Override
    public List<Annotation> getAnnotations(AnnotatedElement annotatedElement) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        this.scan((index, annotation) -> annotations.add((Annotation)annotation), (Class)annotatedElement, annotation -> ObjectUtil.notEqual(annotation, annotatedElement));
        return annotations;
    }
}

