/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.resource;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;

public class UrlResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    protected URL url;
    protected String name;

    public UrlResource(URL url) {
        this(url, null);
    }

    public UrlResource(URL url, String name) {
        this.url = url;
        this.name = ObjectUtil.defaultIfNull(name, null != url ? FileUtil.getName(url.getPath()) : null);
    }

    @Deprecated
    public UrlResource(File file) {
        this.url = URLUtil.getURL(file);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getStream() throws NoResourceException {
        if (null == this.url) {
            throw new NoResourceException("Resource [{}] not exist!", this.url);
        }
        return URLUtil.getStream(this.url);
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return URLUtil.getReader(this.url, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readStr(Charset charset) throws IORuntimeException {
        BufferedReader reader = null;
        try {
            reader = this.getReader(charset);
            String string = IoUtil.read(reader);
            return string;
        }
        finally {
            IoUtil.close(reader);
        }
    }

    @Override
    public String readUtf8Str() throws IORuntimeException {
        return this.readStr(CharsetUtil.CHARSET_UTF_8);
    }

    @Override
    public byte[] readBytes() throws IORuntimeException {
        InputStream in = null;
        try {
            in = this.getStream();
            byte[] byArray = IoUtil.readBytes(in);
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public File getFile() {
        return FileUtil.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

