/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.CopiedIter;
import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.collection.TransIter;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrJoiner;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class IterUtil {
    public static <T> Iterator<T> getIter(Iterable<T> iterable) {
        return null == iterable ? null : iterable.iterator();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || IterUtil.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        return null == Iterator2 || false == Iterator2.hasNext();
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && IterUtil.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        return null != Iterator2 && Iterator2.hasNext();
    }

    public static boolean hasNull(Iterable<?> iter) {
        return IterUtil.hasNull(null == iter ? null : iter.iterator());
    }

    public static boolean hasNull(Iterator<?> iter) {
        if (null == iter) {
            return true;
        }
        while (iter.hasNext()) {
            if (null != iter.next()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Iterable<?> iter) {
        return IterUtil.isAllNull(null == iter ? null : iter.iterator());
    }

    public static boolean isAllNull(Iterator<?> iter) {
        return null == IterUtil.getFirstNoneNull(iter);
    }

    public static <T> Map<T, Integer> countMap(Iterator<T> iter) {
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        if (null != iter) {
            while (iter.hasNext()) {
                T t = iter.next();
                countMap.put(t, countMap.getOrDefault(t, 0) + 1);
            }
        }
        return countMap;
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterator<V> iter, String fieldName) {
        return IterUtil.toMap(iter, new HashMap(), (V value) -> ReflectUtil.getFieldValue(value, fieldName));
    }

    public static <K, V> Map<K, V> fieldValueAsMap(Iterator<?> iter, String fieldNameForKey, String fieldNameForValue) {
        return IterUtil.toMap(iter, new HashMap(), (E value) -> ReflectUtil.getFieldValue(value, fieldNameForKey), (E value) -> ReflectUtil.getFieldValue(value, fieldNameForValue));
    }

    public static <V> List<Object> fieldValueList(Iterable<V> iterable, String fieldName) {
        return IterUtil.fieldValueList(IterUtil.getIter(iterable), fieldName);
    }

    public static <V> List<Object> fieldValueList(Iterator<V> iter, String fieldName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (null != iter) {
            while (iter.hasNext()) {
                V value = iter.next();
                result.add(ReflectUtil.getFieldValue(value, fieldName));
            }
        }
        return result;
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return StrJoiner.of(conjunction).append(iterator).toString();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, String prefix, String suffix) {
        return StrJoiner.of(conjunction, prefix, suffix).setWrapElement(true).append(iterator).toString();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, Function<T, ? extends CharSequence> func) {
        if (null == iterator) {
            return null;
        }
        return StrJoiner.of(conjunction).append(iterator, func).toString();
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (IterUtil.isNotEmpty(entryIter)) {
            for (Map.Entry<K, V> entry : entryIter) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values) {
        return IterUtil.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values, boolean isOrder) {
        return IterUtil.toMap(null == keys ? null : keys.iterator(), null == values ? null : values.iterator(), isOrder);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values) {
        return IterUtil.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values, boolean isOrder) {
        HashMap<K, Object> resultMap = MapUtil.newHashMap(isOrder);
        if (IterUtil.isNotEmpty(keys)) {
            while (keys.hasNext()) {
                resultMap.put(keys.next(), null != values && values.hasNext() ? (Object)values.next() : null);
            }
        }
        return resultMap;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IterUtil.toListMap(iterable, keyMapper, v -> v);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IterUtil.toListMap(MapUtil.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Map<K, List<V>> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapUtil.newHashMap();
        }
        if (ObjectUtil.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.computeIfAbsent(keyMapper.apply(value), k -> new ArrayList()).add(valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IterUtil.toMap(iterable, keyMapper, (T v) -> v);
    }

    public static <T, K, V> Map<K, V> toMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IterUtil.toMap(MapUtil.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, V> toMap(Map<K, V> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapUtil.newHashMap();
        }
        if (ObjectUtil.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <E> List<E> toList(Iterable<E> iter) {
        if (null == iter) {
            return null;
        }
        return IterUtil.toList(iter.iterator());
    }

    public static <E> List<E> toList(Iterator<E> iter) {
        ArrayList<E> list = new ArrayList<E>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return new EnumerationIter<E>(e);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return () -> iter;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.getFirst(iterable.iterator());
    }

    public static <T> T getFirstNoneNull(Iterable<T> iterable) {
        if (null == iterable) {
            return null;
        }
        return IterUtil.getFirstNoneNull(iterable.iterator());
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        if (null != iterator && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> T getFirstNoneNull(Iterator<T> iterator) {
        return (T)IterUtil.firstMatch(iterator, Objects::nonNull);
    }

    public static <T> T firstMatch(Iterator<T> iterator, Matcher<T> matcher) {
        Assert.notNull(matcher, "Matcher must be not null !", new Object[0]);
        if (null != iterator) {
            while (iterator.hasNext()) {
                T next = iterator.next();
                if (!matcher.match(next)) continue;
                return next;
            }
        }
        return null;
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        if (null != iterable) {
            Iterator<?> iterator = iterable.iterator();
            return IterUtil.getElementType(iterator);
        }
        return null;
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        CopiedIter iter2 = new CopiedIter(iterator);
        while (iter2.hasNext()) {
            Object t = iter2.next();
            if (null == t) continue;
            return t.getClass();
        }
        return null;
    }

    public static <T> List<T> edit(Iterable<T> iter, Editor<T> editor) {
        ArrayList<T> result = new ArrayList<T>();
        if (null == iter) {
            return result;
        }
        for (T t : iter) {
            T modified = null == editor ? t : editor.edit(t);
            if (null == modified) continue;
            result.add(t);
        }
        return result;
    }

    public static <T extends Iterable<E>, E> T filter(T iter, Filter<E> filter) {
        if (null == iter) {
            return null;
        }
        IterUtil.filter(iter.iterator(), filter);
        return iter;
    }

    public static <E> Iterator<E> filter(Iterator<E> iter, Filter<E> filter) {
        if (null == iter || null == filter) {
            return iter;
        }
        while (iter.hasNext()) {
            if (filter.accept(iter.next())) continue;
            iter.remove();
        }
        return iter;
    }

    public static <E> List<E> filterToList(Iterator<E> iter, Filter<E> filter) {
        ArrayList<E> result = new ArrayList<E>();
        if (null != iter) {
            while (iter.hasNext()) {
                E ele = iter.next();
                if (null != filter && !filter.accept(ele)) continue;
                result.add(ele);
            }
        }
        return result;
    }

    public static <K, V> Map<K, V> toMap(Iterator<V> iterator, Map<K, V> map, Func1<V, K> keyFunc) {
        return IterUtil.toMap(iterator, map, keyFunc, (E value) -> value);
    }

    public static <K, V, E> Map<K, V> toMap(Iterator<E> iterator, Map<K, V> map, Func1<E, K> keyFunc, Func1<E, V> valueFunc) {
        if (null == iterator) {
            return map;
        }
        if (null == map) {
            map = MapUtil.newHashMap(true);
        }
        while (iterator.hasNext()) {
            E element = iterator.next();
            try {
                map.put(keyFunc.call(element), valueFunc.call(element));
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        return map;
    }

    public static <T> Iterator<T> empty() {
        return Collections.emptyIterator();
    }

    public static <F, T> Iterator<T> trans(Iterator<F> iterator, Function<? super F, ? extends T> function) {
        return new TransIter<F, T>(iterator, function);
    }

    public static int size(Iterable<?> iterable) {
        if (null == iterable) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return IterUtil.size(iterable.iterator());
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        if (iterator != null) {
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
        }
        return size;
    }

    public static boolean isEqualList(Iterable<?> list1, Iterable<?> list2) {
        if (list1 == list2) {
            return true;
        }
        Iterator<?> it1 = list1.iterator();
        Iterator<?> it2 = list2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Object obj2;
            Object obj1 = it1.next();
            if (Objects.equals(obj1, obj2 = it2.next())) continue;
            return false;
        }
        return false == (it1.hasNext() || it2.hasNext());
    }

    public static void clear(Iterator<?> iterator) {
        if (null != iterator) {
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }
}

