/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public class VersionComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 8083701245147495562L;
    private static final Pattern PATTERN_PRE_NUMBERS = Pattern.compile("^\\d+");
    public static final VersionComparator INSTANCE = new VersionComparator();

    @Override
    public int compare(String version1, String version2) {
        if (ObjectUtil.equal(version1, version2)) {
            return 0;
        }
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        List<String> v1s = StrUtil.split((CharSequence)version1, '.');
        List<String> v2s = StrUtil.split((CharSequence)version2, '.');
        int diff = 0;
        int minLength = Math.min(v1s.size(), v2s.size());
        for (int i = 0; i < minLength; ++i) {
            int v2Num;
            int v1Num;
            int diff1;
            String v1 = v1s.get(i);
            String v2 = v2s.get(i);
            diff = v1.length() - v2.length();
            if (0 == diff) {
                diff = v1.compareTo(v2);
            } else if (!(NumberUtil.isNumber(v1) && NumberUtil.isNumber(v2) || (diff1 = (v1Num = Convert.toInt(ReUtil.get(PATTERN_PRE_NUMBERS, (CharSequence)v1, 0), 0).intValue()) - (v2Num = Convert.toInt(ReUtil.get(PATTERN_PRE_NUMBERS, (CharSequence)v2, 0), 0).intValue())) == 0)) {
                diff = diff1;
            }
            if (diff != 0) break;
        }
        return diff != 0 ? diff : v1s.size() - v2s.size();
    }
}

