/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class ExcelPicUtil {
    public static Map<String, PictureData> getPicMap(Workbook workbook, int sheetIndex) {
        Assert.notNull((Object)workbook, (String)"Workbook must be not null !", (Object[])new Object[0]);
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        if (workbook instanceof HSSFWorkbook) {
            return ExcelPicUtil.getPicMapXls((HSSFWorkbook)workbook, sheetIndex);
        }
        if (workbook instanceof XSSFWorkbook) {
            return ExcelPicUtil.getPicMapXlsx((XSSFWorkbook)workbook, sheetIndex);
        }
        throw new IllegalArgumentException(StrUtil.format((CharSequence)"Workbook type [{}] is not supported!", (Object[])new Object[]{workbook.getClass()}));
    }

    private static Map<String, PictureData> getPicMapXls(HSSFWorkbook workbook, int sheetIndex) {
        HashMap<String, PictureData> picMap = new HashMap<String, PictureData>();
        List pictures = workbook.getAllPictures();
        if (CollectionUtil.isNotEmpty((Collection)pictures)) {
            HSSFSheet sheet = workbook.getSheetAt(sheetIndex);
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                if (!(shape instanceof HSSFPicture)) continue;
                int pictureIndex = ((HSSFPicture)shape).getPictureIndex() - 1;
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                picMap.put(StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{anchor.getRow1(), anchor.getCol1()}), (PictureData)pictures.get(pictureIndex));
            }
        }
        return picMap;
    }

    private static Map<String, PictureData> getPicMapXlsx(XSSFWorkbook workbook, int sheetIndex) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                if (!(shape instanceof XSSFPicture)) continue;
                XSSFPicture pic = (XSSFPicture)shape;
                CTMarker ctMarker = pic.getPreferredSize().getFrom();
                sheetIndexPicMap.put(StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{ctMarker.getRow(), ctMarker.getCol()}), (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }
}

