/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.cell.values;

import cn.hutool.core.date.DateUtil;
import cn.hutool.poi.excel.ExcelDateUtil;
import cn.hutool.poi.excel.cell.CellValue;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.NumberToTextConverter;

public class NumericCellValue
implements CellValue<Object> {
    private final Cell cell;

    public NumericCellValue(Cell cell) {
        this.cell = cell;
    }

    @Override
    public Object getValue() {
        double value = this.cell.getNumericCellValue();
        CellStyle style = this.cell.getCellStyle();
        if (null != style) {
            long longPart;
            if (ExcelDateUtil.isDateFormat(this.cell)) {
                Date dateCellValue = this.cell.getDateCellValue();
                if ("1899".equals(DateUtil.format((Date)dateCellValue, (String)"yyyy"))) {
                    return DateUtil.format((Date)dateCellValue, (String)style.getDataFormatString());
                }
                return DateUtil.date((Date)dateCellValue);
            }
            String format = style.getDataFormatString();
            if (null != format && format.indexOf(46) < 0 && (double)(longPart = (long)value) == value) {
                return longPart;
            }
        }
        return Double.parseDouble(NumberToTextConverter.toText((double)value));
    }
}

