/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.socket.aio;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.hutool.socket.SocketConfig;
import cn.hutool.socket.SocketRuntimeException;
import cn.hutool.socket.aio.AioSession;
import cn.hutool.socket.aio.IoAction;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;

public class AioClient
implements Closeable {
    private final AioSession session;

    public AioClient(InetSocketAddress address, IoAction<ByteBuffer> ioAction) {
        this(address, ioAction, new SocketConfig());
    }

    public AioClient(InetSocketAddress address, IoAction<ByteBuffer> ioAction, SocketConfig config) {
        this(AioClient.createChannel(address, config.getThreadPoolSize()), ioAction, config);
    }

    public AioClient(AsynchronousSocketChannel channel, IoAction<ByteBuffer> ioAction, SocketConfig config) {
        this.session = new AioSession(channel, ioAction, config);
        ioAction.accept(this.session);
    }

    public <T> AioClient setOption(SocketOption<T> name, T value) throws IOException {
        this.session.getChannel().setOption((SocketOption)name, (Object)value);
        return this;
    }

    public IoAction<ByteBuffer> getIoAction() {
        return this.session.getIoAction();
    }

    public AioClient read() {
        this.session.read();
        return this;
    }

    public AioClient write(ByteBuffer data) {
        this.session.write(data);
        return this;
    }

    @Override
    public void close() {
        this.session.close();
    }

    private static AsynchronousSocketChannel createChannel(InetSocketAddress address, int poolSize) {
        AsynchronousSocketChannel channel;
        try {
            AsynchronousChannelGroup group = AsynchronousChannelGroup.withFixedThreadPool(poolSize, ThreadFactoryBuilder.create().setNamePrefix("Huool-socket-").build());
            channel = AsynchronousSocketChannel.open(group);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        try {
            channel.connect(address).get();
        }
        catch (InterruptedException | ExecutionException e) {
            IoUtil.close((Closeable)channel);
            throw new SocketRuntimeException(e);
        }
        return channel;
    }
}

