/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.read.processor;

import cn.idev.excel.context.AnalysisContext;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.enums.HeadKindEnum;
import cn.idev.excel.enums.RowTypeEnum;
import cn.idev.excel.exception.ExcelAnalysisException;
import cn.idev.excel.exception.ExcelAnalysisStopException;
import cn.idev.excel.metadata.Cell;
import cn.idev.excel.metadata.Head;
import cn.idev.excel.metadata.data.ReadCellData;
import cn.idev.excel.read.listener.ReadListener;
import cn.idev.excel.read.metadata.holder.ReadRowHolder;
import cn.idev.excel.read.metadata.holder.ReadSheetHolder;
import cn.idev.excel.read.metadata.property.ExcelReadHeadProperty;
import cn.idev.excel.read.processor.AnalysisEventProcessor;
import cn.idev.excel.util.BooleanUtils;
import cn.idev.excel.util.ConverterUtils;
import cn.idev.excel.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnalysisEventProcessor
implements AnalysisEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAnalysisEventProcessor.class);

    @Override
    public void extra(AnalysisContext analysisContext) {
        this.dealExtra(analysisContext);
    }

    @Override
    public void endRow(AnalysisContext analysisContext) {
        if (RowTypeEnum.EMPTY.equals((Object)analysisContext.readRowHolder().getRowType())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Empty row!");
            }
            if (analysisContext.readWorkbookHolder().getIgnoreEmptyRow().booleanValue()) {
                return;
            }
        }
        this.dealData(analysisContext);
    }

    @Override
    public void endSheet(AnalysisContext analysisContext) {
        ReadSheetHolder readSheetHolder = analysisContext.readSheetHolder();
        if (BooleanUtils.isTrue(readSheetHolder.getEnded())) {
            return;
        }
        readSheetHolder.setEnded(Boolean.TRUE);
        for (ReadListener<?> readListener : analysisContext.currentReadHolder().readListenerList()) {
            readListener.doAfterAllAnalysed(analysisContext);
        }
    }

    private void dealExtra(AnalysisContext analysisContext) {
        for (ReadListener<?> readListener : analysisContext.currentReadHolder().readListenerList()) {
            try {
                readListener.extra(analysisContext.readSheetHolder().getCellExtra(), analysisContext);
            }
            catch (Exception e) {
                this.onException(analysisContext, e);
                break;
            }
            if (readListener.hasNext(analysisContext)) continue;
            throw new ExcelAnalysisStopException();
        }
    }

    private void onException(AnalysisContext analysisContext, Exception e) {
        for (ReadListener<?> readListenerException : analysisContext.currentReadHolder().readListenerList()) {
            try {
                readListenerException.onException(e, analysisContext);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e1) {
                throw new ExcelAnalysisException(e1.getMessage(), e1);
            }
        }
    }

    private void dealData(AnalysisContext analysisContext) {
        boolean isData;
        ReadRowHolder readRowHolder = analysisContext.readRowHolder();
        Map<Integer, Cell> cellDataMap = readRowHolder.getCellMap();
        readRowHolder.setCurrentRowAnalysisResult(cellDataMap);
        int rowIndex = readRowHolder.getRowIndex();
        int currentHeadRowNumber = analysisContext.readSheetHolder().getHeadRowNumber();
        boolean bl = isData = rowIndex >= currentHeadRowNumber;
        if (!isData && currentHeadRowNumber == rowIndex + 1) {
            this.buildHead(analysisContext, cellDataMap);
        }
        for (ReadListener<?> readListener : analysisContext.currentReadHolder().readListenerList()) {
            try {
                if (isData) {
                    readListener.invoke(readRowHolder.getCurrentRowAnalysisResult(), analysisContext);
                } else {
                    readListener.invokeHead(cellDataMap, analysisContext);
                }
            }
            catch (Exception e) {
                this.onException(analysisContext, e);
                break;
            }
            if (readListener.hasNext(analysisContext)) continue;
            throw new ExcelAnalysisStopException();
        }
    }

    private void buildHead(AnalysisContext analysisContext, Map<Integer, ReadCellData<?>> cellDataMap) {
        if (MapUtils.isNotEmpty(cellDataMap)) {
            cellDataMap.entrySet().stream().filter(entry -> CellDataTypeEnum.EMPTY != ((ReadCellData)entry.getValue()).getType()).forEach(entry -> analysisContext.readSheetHolder().setMaxNotEmptyDataHeadSize((Integer)entry.getKey()));
        }
        if (!HeadKindEnum.CLASS.equals((Object)analysisContext.currentReadHolder().excelReadHeadProperty().getHeadKind())) {
            return;
        }
        Map<Integer, String> dataMap = ConverterUtils.convertToStringMap(cellDataMap, analysisContext);
        ExcelReadHeadProperty excelHeadPropertyData = analysisContext.readSheetHolder().excelReadHeadProperty();
        Map<Integer, Head> headMapData = excelHeadPropertyData.getHeadMap();
        HashMap<Integer, Head> tmpHeadMap = new HashMap<Integer, Head>(headMapData.size() * 4 / 3 + 1);
        block0: for (Map.Entry<Integer, Head> entry2 : headMapData.entrySet()) {
            Head headData = entry2.getValue();
            if (headData.getForceIndex().booleanValue() || !headData.getForceName().booleanValue()) {
                tmpHeadMap.put(entry2.getKey(), headData);
                continue;
            }
            List<String> headNameList = headData.getHeadNameList();
            String headName = headNameList.get(headNameList.size() - 1);
            for (Map.Entry<Integer, String> stringEntry : dataMap.entrySet()) {
                if (stringEntry == null) continue;
                String headString = stringEntry.getValue();
                Integer stringKey = stringEntry.getKey();
                if (StringUtils.isEmpty(headString)) continue;
                if (analysisContext.currentReadHolder().globalConfiguration().getAutoTrim().booleanValue()) {
                    headString = headString.trim();
                }
                if (!headName.equals(headString)) continue;
                headData.setColumnIndex(stringKey);
                tmpHeadMap.put(stringKey, headData);
                continue block0;
            }
        }
        excelHeadPropertyData.setHeadMap(tmpHeadMap);
    }
}

