/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.util;

import cn.idev.excel.util.FieldUtils;
import java.lang.reflect.Field;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class PoiUtils {
    public static final BitField CUSTOM_HEIGHT = BitFieldFactory.getInstance((int)1600);
    private static final Field ROW_RECORD_FIELD = FieldUtils.getField(HSSFRow.class, "row", true);

    public static boolean customHeight(Row row) {
        if (row instanceof XSSFRow) {
            XSSFRow xssfRow = (XSSFRow)row;
            return xssfRow.getCTRow().getCustomHeight();
        }
        if (row instanceof HSSFRow) {
            HSSFRow hssfRow = (HSSFRow)row;
            try {
                RowRecord record = (RowRecord)ROW_RECORD_FIELD.get(hssfRow);
                return CUSTOM_HEIGHT.getValue((int)record.getOptionFlags()) == 1;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }
}

