/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.style;

import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.util.ListUtils;
import cn.idev.excel.write.handler.context.CellWriteHandlerContext;
import cn.idev.excel.write.metadata.style.WriteCellStyle;
import cn.idev.excel.write.style.AbstractCellStyleStrategy;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class HorizontalCellStyleStrategy
extends AbstractCellStyleStrategy {
    private WriteCellStyle headWriteCellStyle;
    private List<WriteCellStyle> contentWriteCellStyleList;

    public HorizontalCellStyleStrategy() {
    }

    public HorizontalCellStyleStrategy(WriteCellStyle headWriteCellStyle, List<WriteCellStyle> contentWriteCellStyleList) {
        this.headWriteCellStyle = headWriteCellStyle;
        this.contentWriteCellStyleList = contentWriteCellStyleList;
    }

    public HorizontalCellStyleStrategy(WriteCellStyle headWriteCellStyle, WriteCellStyle contentWriteCellStyle) {
        this.headWriteCellStyle = headWriteCellStyle;
        if (contentWriteCellStyle != null) {
            this.contentWriteCellStyleList = ListUtils.newArrayList(contentWriteCellStyle);
        }
    }

    @Override
    protected void setHeadCellStyle(CellWriteHandlerContext context) {
        if (this.stopProcessing(context) || this.headWriteCellStyle == null) {
            return;
        }
        WriteCellData<?> cellData = context.getFirstCellData();
        WriteCellStyle.merge(this.headWriteCellStyle, cellData.getOrCreateStyle());
    }

    @Override
    protected void setContentCellStyle(CellWriteHandlerContext context) {
        if (this.stopProcessing(context) || CollectionUtils.isEmpty(this.contentWriteCellStyleList)) {
            return;
        }
        WriteCellData<?> cellData = context.getFirstCellData();
        if (context.getRelativeRowIndex() == null || context.getRelativeRowIndex() <= 0) {
            WriteCellStyle.merge(this.contentWriteCellStyleList.get(0), cellData.getOrCreateStyle());
        } else {
            WriteCellStyle.merge(this.contentWriteCellStyleList.get(context.getRelativeRowIndex() % this.contentWriteCellStyleList.size()), cellData.getOrCreateStyle());
        }
    }

    protected boolean stopProcessing(CellWriteHandlerContext context) {
        return context.getFirstCellData() == null;
    }

    public WriteCellStyle getHeadWriteCellStyle() {
        return this.headWriteCellStyle;
    }

    public List<WriteCellStyle> getContentWriteCellStyleList() {
        return this.contentWriteCellStyleList;
    }

    public void setHeadWriteCellStyle(WriteCellStyle headWriteCellStyle) {
        this.headWriteCellStyle = headWriteCellStyle;
    }

    public void setContentWriteCellStyleList(List<WriteCellStyle> contentWriteCellStyleList) {
        this.contentWriteCellStyleList = contentWriteCellStyleList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HorizontalCellStyleStrategy)) {
            return false;
        }
        HorizontalCellStyleStrategy other = (HorizontalCellStyleStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WriteCellStyle this$headWriteCellStyle = this.getHeadWriteCellStyle();
        WriteCellStyle other$headWriteCellStyle = other.getHeadWriteCellStyle();
        if (this$headWriteCellStyle == null ? other$headWriteCellStyle != null : !((Object)this$headWriteCellStyle).equals(other$headWriteCellStyle)) {
            return false;
        }
        List<WriteCellStyle> this$contentWriteCellStyleList = this.getContentWriteCellStyleList();
        List<WriteCellStyle> other$contentWriteCellStyleList = other.getContentWriteCellStyleList();
        return !(this$contentWriteCellStyleList == null ? other$contentWriteCellStyleList != null : !((Object)this$contentWriteCellStyleList).equals(other$contentWriteCellStyleList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HorizontalCellStyleStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        WriteCellStyle $headWriteCellStyle = this.getHeadWriteCellStyle();
        result = result * 59 + ($headWriteCellStyle == null ? 43 : ((Object)$headWriteCellStyle).hashCode());
        List<WriteCellStyle> $contentWriteCellStyleList = this.getContentWriteCellStyleList();
        result = result * 59 + ($contentWriteCellStyleList == null ? 43 : ((Object)$contentWriteCellStyleList).hashCode());
        return result;
    }
}

