/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.framework.datapermission.core.rule.dept;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.iocoder.yudao.framework.common.enums.UserTypeEnum;
import cn.iocoder.yudao.framework.common.util.collection.CollectionUtils;
import cn.iocoder.yudao.framework.common.util.json.JsonUtils;
import cn.iocoder.yudao.framework.datapermission.core.rule.DataPermissionRule;
import cn.iocoder.yudao.framework.mybatis.core.dataobject.BaseDO;
import cn.iocoder.yudao.framework.mybatis.core.util.MyBatisUtils;
import cn.iocoder.yudao.framework.security.core.LoginUser;
import cn.iocoder.yudao.framework.security.core.util.SecurityFrameworkUtils;
import cn.iocoder.yudao.module.system.api.permission.PermissionApi;
import cn.iocoder.yudao.module.system.api.permission.dto.DeptDataPermissionRespDTO;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeptDataPermissionRule
implements DataPermissionRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeptDataPermissionRule.class);
    protected static final String CONTEXT_KEY = DeptDataPermissionRule.class.getSimpleName();
    private static final String DEPT_COLUMN_NAME = "dept_id";
    private static final String USER_COLUMN_NAME = "user_id";
    static final Expression EXPRESSION_NULL = new NullValue();
    private final PermissionApi permissionApi;
    private final Map<String, String> deptColumns = new HashMap<String, String>();
    private final Map<String, String> userColumns = new HashMap<String, String>();
    private final Set<String> TABLE_NAMES = new HashSet<String>();

    @Override
    public Set<String> getTableNames() {
        return this.TABLE_NAMES;
    }

    @Override
    public Expression getExpression(String string, Alias alias) {
        LoginUser loginUser = SecurityFrameworkUtils.getLoginUser();
        if (loginUser == null) {
            return null;
        }
        if (ObjectUtil.notEqual((Object)loginUser.getUserType(), (Object)UserTypeEnum.ADMIN.getValue())) {
            return null;
        }
        DeptDataPermissionRespDTO deptDataPermissionRespDTO = (DeptDataPermissionRespDTO)loginUser.getContext(CONTEXT_KEY, DeptDataPermissionRespDTO.class);
        if (deptDataPermissionRespDTO == null) {
            deptDataPermissionRespDTO = (DeptDataPermissionRespDTO)this.permissionApi.getDeptDataPermission(loginUser.getId()).getCheckedData();
            if (deptDataPermissionRespDTO == null) {
                log.error("[getExpression][LoginUser({}) \u83b7\u53d6\u6570\u636e\u6743\u9650\u4e3a null]", (Object)JsonUtils.toJsonString((Object)loginUser));
                throw new NullPointerException(String.format("LoginUser(%d) Table(%s/%s) \u672a\u8fd4\u56de\u6570\u636e\u6743\u9650", loginUser.getId(), string, alias.getName()));
            }
            loginUser.setContext(CONTEXT_KEY, (Object)deptDataPermissionRespDTO);
        }
        if (deptDataPermissionRespDTO.getAll().booleanValue()) {
            return null;
        }
        if (CollUtil.isEmpty((Collection)deptDataPermissionRespDTO.getDeptIds()) && Boolean.FALSE.equals(deptDataPermissionRespDTO.getSelf())) {
            return new EqualsTo(null, null);
        }
        Expression expression = this.buildDeptExpression(string, alias, deptDataPermissionRespDTO.getDeptIds());
        Expression expression2 = this.buildUserExpression(string, alias, deptDataPermissionRespDTO.getSelf(), loginUser.getId());
        if (expression == null && expression2 == null) {
            log.warn("[getExpression][LoginUser({}) Table({}/{}) DeptDataPermission({}) \u6784\u5efa\u7684\u6761\u4ef6\u4e3a\u7a7a]", new Object[]{JsonUtils.toJsonString((Object)loginUser), string, alias, JsonUtils.toJsonString((Object)deptDataPermissionRespDTO)});
            return EXPRESSION_NULL;
        }
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new ParenthesedExpressionList(new Expression[]{new OrExpression(expression, expression2)});
    }

    private Expression buildDeptExpression(String string, Alias alias, Set<Long> set) {
        String string2 = this.deptColumns.get(string);
        if (StrUtil.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (CollUtil.isEmpty(set)) {
            return null;
        }
        return new InExpression((Expression)MyBatisUtils.buildColumn((String)string, (Alias)alias, (String)string2), (Expression)new ParenthesedExpressionList(new ExpressionList(CollectionUtils.convertList(set, LongValue::new))));
    }

    private Expression buildUserExpression(String string, Alias alias, Boolean bl, Long l) {
        if (Boolean.FALSE.equals(bl)) {
            return null;
        }
        String string2 = this.userColumns.get(string);
        if (StrUtil.isEmpty((CharSequence)string2)) {
            return null;
        }
        return new EqualsTo((Expression)MyBatisUtils.buildColumn((String)string, (Alias)alias, (String)string2), (Expression)new LongValue(l.longValue()));
    }

    public void addDeptColumn(Class<? extends BaseDO> clazz) {
        this.addDeptColumn(clazz, DEPT_COLUMN_NAME);
    }

    public void addDeptColumn(Class<? extends BaseDO> clazz, String string) {
        String string2 = TableInfoHelper.getTableInfo(clazz).getTableName();
        this.addDeptColumn(string2, string);
    }

    public void addDeptColumn(String string, String string2) {
        this.deptColumns.put(string, string2);
        this.TABLE_NAMES.add(string);
    }

    public void addUserColumn(Class<? extends BaseDO> clazz) {
        this.addUserColumn(clazz, USER_COLUMN_NAME);
    }

    public void addUserColumn(Class<? extends BaseDO> clazz, String string) {
        String string2 = TableInfoHelper.getTableInfo(clazz).getTableName();
        this.addUserColumn(string2, string);
    }

    public void addUserColumn(String string, String string2) {
        this.userColumns.put(string, string2);
        this.TABLE_NAMES.add(string);
    }

    @Generated
    public DeptDataPermissionRule(PermissionApi permissionApi) {
        this.permissionApi = permissionApi;
    }
}

