/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.framework.datapermission.core.aop;

import cn.iocoder.yudao.framework.datapermission.core.annotation.DataPermission;
import cn.iocoder.yudao.framework.datapermission.core.aop.DataPermissionContextHolder;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.MethodClassKey;
import org.springframework.core.annotation.AnnotationUtils;

@DataPermission
public class DataPermissionAnnotationInterceptor
implements MethodInterceptor {
    static final DataPermission DATA_PERMISSION_NULL = DataPermissionAnnotationInterceptor.class.getAnnotation(DataPermission.class);
    private final Map<MethodClassKey, DataPermission> dataPermissionCache = new ConcurrentHashMap<MethodClassKey, DataPermission>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        DataPermission dataPermission = this.findAnnotation(methodInvocation);
        if (dataPermission != null) {
            DataPermissionContextHolder.add(dataPermission);
        }
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            if (dataPermission != null) {
                DataPermissionContextHolder.remove();
            }
        }
    }

    private DataPermission findAnnotation(MethodInvocation methodInvocation) {
        Object object;
        Class<?> clazz;
        Method method = methodInvocation.getMethod();
        MethodClassKey methodClassKey = new MethodClassKey(method, clazz = (object = methodInvocation.getThis()) != null ? object.getClass() : method.getDeclaringClass());
        DataPermission dataPermission = this.dataPermissionCache.get(methodClassKey);
        if (dataPermission != null) {
            return dataPermission != DATA_PERMISSION_NULL ? dataPermission : null;
        }
        dataPermission = (DataPermission)AnnotationUtils.findAnnotation((Method)method, DataPermission.class);
        if (dataPermission == null) {
            dataPermission = (DataPermission)AnnotationUtils.findAnnotation(clazz, DataPermission.class);
        }
        this.dataPermissionCache.put(methodClassKey, dataPermission != null ? dataPermission : DATA_PERMISSION_NULL);
        return dataPermission;
    }

    @Generated
    public Map<MethodClassKey, DataPermission> getDataPermissionCache() {
        return this.dataPermissionCache;
    }
}

