/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.framework.datapermission.core.rule;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.iocoder.yudao.framework.datapermission.core.annotation.DataPermission;
import cn.iocoder.yudao.framework.datapermission.core.aop.DataPermissionContextHolder;
import cn.iocoder.yudao.framework.datapermission.core.rule.DataPermissionRule;
import cn.iocoder.yudao.framework.datapermission.core.rule.DataPermissionRuleFactory;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class DataPermissionRuleFactoryImpl
implements DataPermissionRuleFactory {
    private final List<DataPermissionRule> rules;

    @Override
    public List<DataPermissionRule> getDataPermissionRules() {
        return this.rules;
    }

    @Override
    public List<DataPermissionRule> getDataPermissionRule(String string) {
        if (CollUtil.isEmpty(this.rules)) {
            return Collections.emptyList();
        }
        DataPermission dataPermission = DataPermissionContextHolder.get();
        if (dataPermission == null) {
            return this.rules;
        }
        if (!dataPermission.enable()) {
            return Collections.emptyList();
        }
        if (ArrayUtil.isNotEmpty((Object[])dataPermission.includeRules())) {
            return this.rules.stream().filter(dataPermissionRule -> ArrayUtil.contains((Object[])dataPermission.includeRules(), dataPermissionRule.getClass())).collect(Collectors.toList());
        }
        if (ArrayUtil.isNotEmpty((Object[])dataPermission.excludeRules())) {
            return this.rules.stream().filter(dataPermissionRule -> !ArrayUtil.contains((Object[])dataPermission.excludeRules(), dataPermissionRule.getClass())).collect(Collectors.toList());
        }
        return this.rules;
    }

    @Generated
    public DataPermissionRuleFactoryImpl(List<DataPermissionRule> list) {
        this.rules = list;
    }
}

