/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.framework.redis.config;

import cn.iocoder.yudao.framework.redis.config.YudaoCacheProperties;
import cn.iocoder.yudao.framework.redis.config.YudaoRedisAutoConfiguration;
import cn.iocoder.yudao.framework.redis.core.TimeoutRedisCacheManager;
import cn.iocoder.yudao.framework.redis.properties.RedisLockProperties;
import cn.iocoder.yudao.framework.redis.utils.RedisLockUtils;
import cn.iocoder.yudao.framework.redis.utils.RedisUtils;
import java.util.Objects;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.BatchStrategies;
import org.springframework.data.redis.cache.BatchStrategy;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.StringUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={CacheProperties.class, YudaoCacheProperties.class, RedisLockProperties.class})
@EnableCaching
public class YudaoCacheAutoConfiguration {
    private RedisLockProperties redisLockProperties;

    public YudaoCacheAutoConfiguration(RedisLockProperties redisLockProperties) {
        this.redisLockProperties = redisLockProperties;
    }

    @Bean
    @Primary
    public RedisCacheConfiguration redisCacheConfiguration(CacheProperties cacheProperties) {
        RedisCacheConfiguration redisCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
        redisCacheConfiguration = redisCacheConfiguration.computePrefixWith(string -> {
            Object object = cacheProperties.getRedis().getKeyPrefix();
            if (StringUtils.hasText((String)object)) {
                object = ((String)object).lastIndexOf(":") == -1 ? (String)object + ":" : object;
                return (String)object + string + ":";
            }
            return string + ":";
        });
        redisCacheConfiguration = redisCacheConfiguration.serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(YudaoRedisAutoConfiguration.buildRedisSerializer()));
        CacheProperties.Redis redis = cacheProperties.getRedis();
        if (redis.getTimeToLive() != null) {
            redisCacheConfiguration = redisCacheConfiguration.entryTtl(redis.getTimeToLive());
        }
        if (!redis.isCacheNullValues()) {
            redisCacheConfiguration = redisCacheConfiguration.disableCachingNullValues();
        }
        if (!redis.isUseKeyPrefix()) {
            redisCacheConfiguration = redisCacheConfiguration.disableKeyPrefix();
        }
        return redisCacheConfiguration;
    }

    @Bean
    public RedisCacheManager redisCacheManager(RedisTemplate<String, Object> redisTemplate, RedisCacheConfiguration redisCacheConfiguration, YudaoCacheProperties yudaoCacheProperties) {
        RedisConnectionFactory redisConnectionFactory = Objects.requireNonNull(redisTemplate.getConnectionFactory());
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory, (BatchStrategy)BatchStrategies.scan((int)yudaoCacheProperties.getRedisScanBatchSize()));
        return new TimeoutRedisCacheManager(redisCacheWriter, redisCacheConfiguration);
    }

    @Bean
    @ConditionalOnProperty(prefix="redis.lock", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public RedisLockUtils redisLockUtils(StringRedisTemplate stringRedisTemplate) {
        RedisLockUtils redisLockUtils = new RedisLockUtils(stringRedisTemplate, this.redisLockProperties);
        return redisLockUtils;
    }

    @Bean
    public RedisUtils redisUtils(RedisTemplate redisTemplate) {
        RedisUtils redisUtils = new RedisUtils();
        redisUtils.setRedisTemplate((RedisTemplate<String, Object>)redisTemplate);
        return redisUtils;
    }
}

