/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.framework.redis.config;

import cn.hutool.core.util.ReflectUtil;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.redisson.spring.starter.RedissonAutoConfigurationV2;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

@AutoConfiguration(before={RedissonAutoConfigurationV2.class})
public class YudaoRedisAutoConfiguration {
    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer(RedisSerializer.string());
        redisTemplate.setHashKeySerializer(RedisSerializer.string());
        redisTemplate.setValueSerializer(YudaoRedisAutoConfiguration.buildRedisSerializer());
        redisTemplate.setHashValueSerializer(YudaoRedisAutoConfiguration.buildRedisSerializer());
        return redisTemplate;
    }

    public static RedisSerializer<?> buildRedisSerializer() {
        RedisSerializer redisSerializer = RedisSerializer.json();
        ObjectMapper objectMapper = (ObjectMapper)ReflectUtil.getFieldValue((Object)redisSerializer, (String)"mapper");
        objectMapper.registerModules(new Module[]{new JavaTimeModule()});
        return redisSerializer;
    }
}

