/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.framework.redis.utils;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtils {
    private static Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private RedisTemplate<String, Object> redisTemplate;

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean expire(String string, long l) {
        this.checkCacheKey(string);
        try {
            if (l > 0L) {
                this.redisTemplate.expire((Object)string, l, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public long getExpire(String string) {
        this.checkCacheKey(string);
        return this.redisTemplate.getExpire((Object)string, TimeUnit.SECONDS);
    }

    public boolean hasKey(String string) {
        this.checkCacheKey(string);
        try {
            return this.redisTemplate.hasKey((Object)string);
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public void delete(String ... stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray.length == 1) {
                this.redisTemplate.delete((Object)stringArray[0]);
            } else {
                this.redisTemplate.delete(Arrays.asList(stringArray));
            }
        }
    }

    public Object get(String string) {
        this.checkCacheKey(string);
        return string == null ? null : this.redisTemplate.opsForValue().get((Object)string);
    }

    public boolean set(String string, Object object) {
        this.checkCacheKey(string);
        try {
            this.redisTemplate.opsForValue().set((Object)string, object);
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public boolean set(String string, Object object, long l) {
        this.checkCacheKey(string);
        try {
            if (l > 0L) {
                this.redisTemplate.opsForValue().set((Object)string, object, l, TimeUnit.SECONDS);
            } else {
                this.set(string, object);
            }
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public boolean set(String string, Object object, long l, TimeUnit timeUnit) {
        this.checkCacheKey(string);
        try {
            if (l > 0L) {
                this.redisTemplate.opsForValue().set((Object)string, object, l, timeUnit);
            } else {
                this.set(string, object);
            }
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public long incr(String string, long l) {
        this.checkCacheKey(string);
        Preconditions.checkArgument((l > 0L ? 1 : 0) != 0, (Object)"\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        return this.redisTemplate.opsForValue().increment((Object)string, l);
    }

    public long decr(String string, long l) {
        this.checkCacheKey(string);
        Preconditions.checkArgument((l > 0L ? 1 : 0) != 0, (Object)"\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        return this.redisTemplate.opsForValue().increment((Object)string, -l);
    }

    public Object hashGet(String string, String string2) {
        this.checkCacheKey(string);
        Preconditions.checkNotNull((Object)string2, (Object)String.format("%s must be have value!", "item"));
        return this.redisTemplate.opsForHash().get((Object)string, (Object)string2);
    }

    public Map<Object, Object> hashMapGet(String string) {
        this.checkCacheKey(string);
        return this.redisTemplate.opsForHash().entries((Object)string);
    }

    public boolean hashMapSet(String string, Map<String, Object> map) {
        this.checkCacheKey(string);
        try {
            this.redisTemplate.opsForHash().putAll((Object)string, map);
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public boolean hashMapSet(String string, Map<String, Object> map, long l) {
        this.checkCacheKey(string);
        try {
            this.redisTemplate.opsForHash().putAll((Object)string, map);
            if (l > 0L) {
                this.expire(string, l);
            }
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public boolean hashSet(String string, String string2, Object object) {
        this.checkCacheKey(string);
        Preconditions.checkNotNull((Object)string2, (Object)String.format("%s must be have value!", "item"));
        try {
            this.redisTemplate.opsForHash().put((Object)string, (Object)string2, object);
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public boolean hashSet(String string, String string2, Object object, long l) {
        this.checkCacheKey(string);
        Preconditions.checkNotNull((Object)string2, (Object)String.format("%s must be have value!", "item"));
        try {
            this.redisTemplate.opsForHash().put((Object)string, (Object)string2, object);
            if (l > 0L) {
                this.expire(string, l);
            }
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public void hashDelete(String string, Object ... objectArray) {
        this.checkCacheKey(string);
        Preconditions.checkNotNull((Object)objectArray);
        this.redisTemplate.opsForHash().delete((Object)string, objectArray);
    }

    public boolean hashHasKey(String string, String string2) {
        this.checkCacheKey(string);
        Preconditions.checkNotNull((Object)string2, (Object)String.format("%s must be have value!", "item"));
        return this.redisTemplate.opsForHash().hasKey((Object)string, (Object)string2);
    }

    public long hashIncr(String string, String string2, long l) {
        this.checkCacheKey(string);
        Preconditions.checkNotNull((Object)string2, (Object)String.format("%s must be have value!", "item"));
        Preconditions.checkArgument((l > 0L ? 1 : 0) != 0, (Object)"\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        return this.redisTemplate.opsForHash().increment((Object)string, (Object)string2, l);
    }

    public long hashDecr(String string, String string2, long l) {
        this.checkCacheKey(string);
        Preconditions.checkNotNull((Object)string2, (Object)String.format("%s must be have value!", "item"));
        Preconditions.checkArgument((l > 0L ? 1 : 0) != 0, (Object)"\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        return this.redisTemplate.opsForHash().increment((Object)string, (Object)string2, -l);
    }

    public Set<Object> setGet(String string) {
        this.checkCacheKey(string);
        try {
            return this.redisTemplate.opsForSet().members((Object)string);
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return null;
        }
    }

    public boolean setHasKey(String string, Object object) {
        this.checkCacheKey(string);
        try {
            return this.redisTemplate.opsForSet().isMember((Object)string, object);
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public long setSet(String string, Object ... objectArray) {
        this.checkCacheKey(string);
        try {
            return this.redisTemplate.opsForSet().add((Object)string, objectArray);
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return 0L;
        }
    }

    public long setSetTime(String string, long l, Object ... objectArray) {
        this.checkCacheKey(string);
        try {
            Long l2 = this.redisTemplate.opsForSet().add((Object)string, objectArray);
            if (l > 0L) {
                this.expire(string, l);
            }
            return l2;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return 0L;
        }
    }

    public long getSetSize(String string) {
        this.checkCacheKey(string);
        try {
            return this.redisTemplate.opsForSet().size((Object)string);
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return 0L;
        }
    }

    public long setRemove(String string, Object ... objectArray) {
        this.checkCacheKey(string);
        try {
            Long l = this.redisTemplate.opsForSet().remove((Object)string, objectArray);
            return l;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return 0L;
        }
    }

    public List<Object> listGet(String string, long l, long l2) {
        this.checkCacheKey(string);
        try {
            return this.redisTemplate.opsForList().range((Object)string, l, l2);
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return null;
        }
    }

    public long listGetSize(String string) {
        this.checkCacheKey(string);
        try {
            return this.redisTemplate.opsForList().size((Object)string);
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return 0L;
        }
    }

    public Object listGetIndex(String string, long l) {
        this.checkCacheKey(string);
        try {
            return this.redisTemplate.opsForList().index((Object)string, l);
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return null;
        }
    }

    public boolean listSet(String string, Object object) {
        this.checkCacheKey(string);
        try {
            this.redisTemplate.opsForList().rightPush((Object)string, object);
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public boolean listSet(String string, Object object, long l) {
        this.checkCacheKey(string);
        try {
            this.redisTemplate.opsForList().rightPush((Object)string, object);
            if (l > 0L) {
                this.expire(string, l);
            }
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public boolean listSet(String string, List<Object> list) {
        this.checkCacheKey(string);
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)string, list);
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public boolean listSet(String string, List<Object> list, long l) {
        this.checkCacheKey(string);
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)string, list);
            if (l > 0L) {
                this.expire(string, l);
            }
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public boolean listUpdateByIndex(String string, long l, Object object) {
        this.checkCacheKey(string);
        try {
            this.redisTemplate.opsForList().set((Object)string, l, object);
            return true;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return false;
        }
    }

    public long listRemove(String string, long l, Object object) {
        this.checkCacheKey(string);
        try {
            Long l2 = this.redisTemplate.opsForList().remove((Object)string, l, object);
            return l2;
        }
        catch (Exception exception) {
            log.error("\u64cd\u4f5credis\u5f02\u5e38:", (Throwable)exception);
            return 0L;
        }
    }

    private void checkCacheKey(String string) {
        Preconditions.checkNotNull((Object)string, (Object)String.format("%s must be have value!", "key"));
    }
}

