/*
 * Decompiled with CFR 0.152.
 */
package cn.iocoder.yudao.framework.websocket.core.handler;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.iocoder.yudao.framework.common.util.json.JsonUtils;
import cn.iocoder.yudao.framework.tenant.core.util.TenantUtils;
import cn.iocoder.yudao.framework.websocket.core.listener.WebSocketMessageListener;
import cn.iocoder.yudao.framework.websocket.core.message.JsonWebSocketMessage;
import cn.iocoder.yudao.framework.websocket.core.util.WebSocketFrameworkUtils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class JsonWebSocketMessageHandler
extends TextWebSocketHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonWebSocketMessageHandler.class);
    private final Map<String, WebSocketMessageListener<Object>> listeners = new HashMap<String, WebSocketMessageListener<Object>>();

    public JsonWebSocketMessageHandler(List<? extends WebSocketMessageListener> list) {
        list.forEach(webSocketMessageListener -> this.listeners.put(webSocketMessageListener.getType(), (WebSocketMessageListener<Object>)webSocketMessageListener));
    }

    protected void handleTextMessage(WebSocketSession webSocketSession, TextMessage textMessage) throws Exception {
        if (textMessage.getPayloadLength() == 0) {
            return;
        }
        if (textMessage.getPayloadLength() == 4 && Objects.equals(textMessage.getPayload(), "ping")) {
            webSocketSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)"pong"));
            return;
        }
        try {
            JsonWebSocketMessage jsonWebSocketMessage = (JsonWebSocketMessage)JsonUtils.parseObject((String)((String)textMessage.getPayload()), JsonWebSocketMessage.class);
            if (jsonWebSocketMessage == null) {
                log.error("[handleTextMessage][session({}) message({}) \u89e3\u6790\u4e3a\u7a7a]", (Object)webSocketSession.getId(), textMessage.getPayload());
                return;
            }
            if (StrUtil.isEmpty((CharSequence)jsonWebSocketMessage.getType())) {
                log.error("[handleTextMessage][session({}) message({}) \u7c7b\u578b\u4e3a\u7a7a]", (Object)webSocketSession.getId(), textMessage.getPayload());
                return;
            }
            WebSocketMessageListener<Object> webSocketMessageListener = this.listeners.get(jsonWebSocketMessage.getType());
            if (webSocketMessageListener == null) {
                log.error("[handleTextMessage][session({}) message({}) \u76d1\u542c\u5668\u4e3a\u7a7a]", (Object)webSocketSession.getId(), textMessage.getPayload());
                return;
            }
            Type type = TypeUtil.getTypeArgument(webSocketMessageListener.getClass(), (int)0);
            Object object = JsonUtils.parseObject((String)jsonWebSocketMessage.getContent(), (Type)type);
            Long l = WebSocketFrameworkUtils.getTenantId(webSocketSession);
            TenantUtils.execute((Long)l, () -> webSocketMessageListener.onMessage(webSocketSession, object));
        }
        catch (Throwable throwable) {
            log.error("[handleTextMessage][session({}) message({}) \u5904\u7406\u5f02\u5e38]", (Object)webSocketSession.getId(), textMessage.getPayload());
        }
    }
}

