/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.init.core;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.init.core.MutilsFunctions;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfig {
    protected static Logger slog = LoggerFactory.getLogger(AbstractConfig.class);
    private static final List<AbstractConfig> MODULES = new ArrayList<AbstractConfig>();
    private static final Map<Type, AbstractConfig> LOADED_CONFIG = new HashMap<Type, AbstractConfig>();
    private static boolean isInit = false;

    protected AbstractConfig() {
        MODULES.add(this);
    }

    public static void init(MutilsFunctions[] functions) {
        if (isInit) {
            slog.error("The function has been initialized and the initialization failed.");
            return;
        }
        isInit = true;
        if (functions == null) {
            slog.info("Function initialized failed, Please check config.");
            return;
        }
        slog.info("The selected function is about to be initialized.");
        for (MutilsFunctions mutilsFunctions : functions) {
            Class<? extends AbstractConfig> clazz = mutilsFunctions.getClazz();
            for (AbstractConfig config : MODULES) {
                Class<?> class1 = config.getClass();
                if (!clazz.equals(class1)) continue;
                String artifactId = mutilsFunctions.getArtifactId();
                config.checkConfig();
                LOADED_CONFIG.put(class1, config);
                slog.info("'{}' initialized successfully.", (Object)artifactId);
            }
        }
        MODULES.clear();
    }

    protected abstract void checkConfig();

    public static <T extends AbstractConfig> T loadConfig(Class<T> configClazz) {
        if (configClazz == null || !LOADED_CONFIG.containsKey(configClazz)) {
            throw new MutilsException("Cant't find Configuation of '" + configClazz.getName() + "' ,Maybe The configuration file is not initialized or empty, Please check the configuration file or select functions.");
        }
        return (T)LOADED_CONFIG.get(configClazz);
    }
}

