/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools;

import cn.minsin.core.tools.DateUtil;
import java.util.Calendar;
import java.util.Date;

public class CalendarUtil {
    private static Calendar calendar = Calendar.getInstance();

    public static int differentDays(Date date1, Date date2) {
        calendar.setTime(date1);
        int day1 = calendar.get(6);
        int year1 = calendar.get(1);
        calendar.setTime(date2);
        int day2 = calendar.get(6);
        int year2 = calendar.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                timeDistance += CalendarUtil.isLeapYear(i) ? 366 : 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public static int getDaysOfMonth(int year, int month) {
        if (month < 0 || month > 12) {
            return 0;
        }
        calendar.set(2, month - 1);
        calendar.set(1, year);
        return calendar.getActualMaximum(5);
    }

    public static int getDaysOfYear(int year) {
        calendar.set(1, year);
        return calendar.getActualMaximum(6);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static Date getQuarterTime(int month, boolean isEnd) {
        int m;
        int[][] array = new int[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}, {10, 11, 12}};
        int season = 1;
        if (month >= 1 && month <= 3) {
            season = 1;
        }
        if (month >= 4 && month <= 6) {
            season = 2;
        }
        if (month >= 7 && month <= 9) {
            season = 3;
        }
        if (month >= 10 && month <= 12) {
            season = 4;
        }
        calendar.set(2, month - 1);
        int year = calendar.get(1);
        int days = 1;
        if (isEnd) {
            m = array[season - 1][2];
            days = CalendarUtil.getDaysOfMonth(year, m);
        } else {
            m = array[season - 1][0];
        }
        calendar.set(2, m - 1);
        calendar.set(5, days);
        return calendar.getTime();
    }

    public static Date getDate(Date date, int days) {
        CalendarUtil.checkDate(date);
        int i = calendar.get(5);
        calendar.set(5, i + days);
        Date time = calendar.getTime();
        System.out.println(DateUtil.date2String(time));
        return time;
    }

    public static int getWeekOfMonth(Date date) {
        CalendarUtil.checkDate(date);
        return calendar.get(8);
    }

    public static int getDayOfYear(Date date) {
        CalendarUtil.checkDate(date);
        return calendar.get(6);
    }

    public static int getDayOfMonth(Date date) {
        CalendarUtil.checkDate(date);
        return calendar.get(5);
    }

    public static int getDayOfWeek(Date date, boolean isChineseWeekend) {
        CalendarUtil.checkDate(date);
        int i = calendar.get(7);
        return isChineseWeekend ? i - 1 : i;
    }

    public static Date getBeginOfDay(Date date) {
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        if (date == null) {
            return null;
        }
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    private static void checkDate(Date date) {
        calendar.setTime(date == null ? new Date() : date);
    }
}

