/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools;

import cn.minsin.core.exception.MutilsErrorException;
import com.alibaba.fastjson.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int BUFFER_SIZE = 2048;

    public static void toZip(String srcDir, OutputStream out) throws MutilsErrorException {
        long start = System.currentTimeMillis();
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            File sourceFile = new File(srcDir);
            ZipUtil.compress(sourceFile, zos, sourceFile.getName(), true);
            long end = System.currentTimeMillis();
            System.out.println("\u538b\u7f29\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end - start) + " ms");
        }
        catch (Exception e) {
            try {
                throw new MutilsErrorException(e, "zip error from ZipUtils");
            }
            catch (Throwable throwable) {
                IOUtils.close(zos);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)zos);
    }

    public static void toZip(List<File> srcFiles, OutputStream out) throws MutilsErrorException {
        long start = System.currentTimeMillis();
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            for (File srcFile : srcFiles) {
                int len;
                byte[] buf = new byte[2048];
                zos.putNextEntry(new ZipEntry(srcFile.getName()));
                FileInputStream in = new FileInputStream(srcFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
            long end = System.currentTimeMillis();
            System.out.println("\u538b\u7f29\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end - start) + " ms");
        }
        catch (Exception e) {
            try {
                throw new MutilsErrorException(e, "zip error from ZipUtils");
            }
            catch (Throwable throwable) {
                IOUtils.close(zos);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)zos);
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean keepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (keepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (keepDirStructure) {
                        ZipUtil.compress(file, zos, name + "/" + file.getName(), keepDirStructure);
                        continue;
                    }
                    ZipUtil.compress(file, zos, file.getName(), keepDirStructure);
                }
            }
        }
    }
}

