/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.qrcode;

import cn.minsin.core.rule.AbstractFunctionRule;
import cn.minsin.core.tools.ModelUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.mutils.qrcode.model.LogoModel;
import org.mutils.qrcode.model.QrcodeModel;

public class QRcodeFunctions
extends AbstractFunctionRule {
    public static InputStream createQRCodeToInputStream(QrcodeModel model) throws WriterException, IOException {
        BufferedImage createImage = QRcodeFunctions.createImage(model);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)createImage, model.getFormat(), os);
        return new ByteArrayInputStream(os.toByteArray());
    }

    public static boolean createQRCodeToOutputStream(QrcodeModel model, OutputStream os) throws WriterException, IOException {
        BufferedImage createImage = QRcodeFunctions.createImage(model);
        ImageIO.write((RenderedImage)createImage, model.getFormat(), os);
        return true;
    }

    protected static BufferedImage createImage(QrcodeModel model) throws WriterException, IOException {
        ModelUtil.verificationField((Object)((Object)model));
        int width = model.getWidth();
        int height = model.getHeight();
        int level = model.getLevel();
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        if (level >= 0 && level <= 5) {
            hints.put(EncodeHintType.MARGIN, level);
        }
        BitMatrix bitMatrix = multiFormatWriter.encode(model.getContent(), BarcodeFormat.QR_CODE, width, height, hints);
        if (level == -1) {
            bitMatrix = QRcodeFunctions.deleteWhite(bitMatrix);
        }
        int w = bitMatrix.getWidth();
        int h = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(w, h, 1);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        return QRcodeFunctions.encode(image, model);
    }

    protected static BufferedImage encode(BufferedImage image, QrcodeModel model) throws IOException {
        LogoModel logoImageModel = model.getLogoImageModel();
        if (logoImageModel != null) {
            ModelUtil.verificationField((Object)((Object)logoImageModel));
            int height = logoImageModel.getHeight();
            int width = logoImageModel.getWidth();
            int x = (image.getWidth() - height) / 2;
            int y = (image.getHeight() - width) / 2;
            Graphics2D g2 = image.createGraphics();
            FileInputStream input = new FileInputStream(logoImageModel.getLogo());
            BufferedImage logo = ImageIO.read(input);
            g2.drawImage(logo, x, y, width, height, null);
            if (logoImageModel.getIsArc().booleanValue()) {
                BasicStroke stroke = new BasicStroke(5.0f, 1, 1);
                g2.setStroke(stroke);
                RoundRectangle2D.Float round = new RoundRectangle2D.Float(x, y, width, height, 20.0f, 20.0f);
                g2.setColor(logoImageModel.getBorderColor());
                g2.draw(round);
                BasicStroke stroke2 = new BasicStroke(1.0f, 1, 1);
                g2.setStroke(stroke2);
                RoundRectangle2D.Float round2 = new RoundRectangle2D.Float(x + 2, y + 2, width - 4, height - 4, 20.0f, 20.0f);
                g2.setColor(new Color(128, 128, 128));
                g2.draw(round2);
            }
            g2.dispose();
            logo.flush();
        }
        image.flush();
        return image;
    }

    public static String decode(InputStream input) throws NotFoundException, IOException {
        BufferedImage image = ImageIO.read(input);
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
        Result result = new MultiFormatReader().decode(bitmap, hints);
        return result.getText();
    }

    protected static BitMatrix deleteWhite(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2];
        int resHeight = rec[3];
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }
}

