/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import com.taiping.common.PropertyFileUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookiesUtils {
    private Cookie cookie;
    private int time = 3600;
    private String path = "/";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String domain = PropertyFileUtil.get("domain.base");

    public CookiesUtils(HttpServletRequest request, HttpServletResponse response) {
        this.setRequest(request);
        this.setResponse(response);
    }

    public void addCookie(String cookiename, String cookievalue) {
        this.cookie = new Cookie(cookiename, cookievalue);
        this.cookie.setPath(this.path);
        this.cookie.setMaxAge(this.time);
        this.cookie.setDomain(this.domain);
        this.response.addCookie(this.cookie);
    }

    public String getCookieByname(String name) {
        Cookie sCookie = null;
        String svalue = null;
        String sname = null;
        Cookie[] cookies = this.request.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            sCookie = cookies[i];
            sname = sCookie.getName();
            if (!sname.equals(name)) continue;
            svalue = sCookie.getValue();
            break;
        }
        return svalue;
    }

    public static void setCookie(HttpServletResponse response, String cookiename, String cookievalue) {
        Cookie cookie = new Cookie(cookiename, cookievalue);
        cookie.setPath("/");
        cookie.setMaxAge(3600);
        response.addCookie(cookie);
    }

    public static String getCookieByname(Cookie[] cookies, String name) {
        Cookie sCookie = null;
        String svalue = null;
        String sname = null;
        for (int i = 0; i < cookies.length; ++i) {
            sCookie = cookies[i];
            sname = sCookie.getName();
            if (!sname.equals(name)) continue;
            svalue = sCookie.getValue();
            break;
        }
        return svalue;
    }

    public static String getCookieByname(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        Cookie sCookie = null;
        String svalue = null;
        String sname = null;
        for (int i = 0; i < cookies.length; ++i) {
            sCookie = cookies[i];
            sname = sCookie.getName();
            if (!sname.equals(name)) continue;
            svalue = sCookie.getValue();
            break;
        }
        return svalue;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setCookie(Cookie cookie) {
        this.cookie = cookie;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

