/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import com.taiping.common.LogUtils;
import com.taiping.common.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    private static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat monthFormat = new SimpleDateFormat("yyyy-MM");

    public static synchronized Date stringToDate(String pattern, String p_date_s) throws ParseException {
        if (p_date_s == null || "".equals(p_date_s)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.parse(p_date_s);
    }

    public static String dateToString(String pattern, Date p_string_d) {
        if (p_string_d == null) {
            return null;
        }
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat(pattern);
        }
        catch (Exception e) {
            LogUtils.error(DateUtils.class, e);
        }
        return sdf.format(p_string_d);
    }

    public static String GetFirstMonth(String date) {
        Calendar calendar = Calendar.getInstance();
        Date dateFrom = null;
        try {
            dateFrom = format.parse(date);
            calendar.setTime(dateFrom);
            int year = calendar.get(1);
            return year + "-" + "01";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String GetMonth(String date) {
        Calendar calendar = Calendar.getInstance();
        Date dateFrom = null;
        try {
            dateFrom = format.parse(date);
            calendar.setTime(dateFrom);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            return year + "-" + StringUtils.Pading(Integer.toString(month), 2, StringUtils.LEFT, '0');
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String GetFirstDateOfMonth(String date) {
        Calendar calendar = Calendar.getInstance();
        Date dateFrom = null;
        try {
            dateFrom = format.parse(date);
            calendar.setTime(dateFrom);
            int count = calendar.get(5) - 1;
            for (int i = 0; i < count; ++i) {
                calendar.add(5, -1);
            }
            return format.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String GetFirstDateOfWeek(String date, int week) {
        Calendar calendar = Calendar.getInstance();
        Date dateFrom = null;
        try {
            dateFrom = format.parse(date);
            calendar.setTime(dateFrom);
            int dow = calendar.get(7) - 2;
            int count = 7 * week;
            for (int i = 0; i < count + dow; ++i) {
                calendar.add(5, -1);
            }
            return format.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDateTime(String bir, String string) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(string);
        Date date = format.parse(bir);
        return date;
    }

    public static Date getCurrentDateTime() {
        Calendar c = Calendar.getInstance();
        return c.getTime();
    }

    public static Date parseCurrentDateTime(String format) {
        Calendar c = Calendar.getInstance();
        Date d = null;
        try {
            d = DateUtils.parseDateTime(c.getTime(), format);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public static String formatCurrentDateTime(String format) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(c.getTime());
    }

    public static String formatDateTime(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static Date parseDateTime(String dateStr, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.parse(dateStr);
    }

    public static Date parseDateTime(Date date, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.parse(dateFormat.format(date));
    }

    public static Date getMondayOfWeek(Date date) {
        Calendar monday = Calendar.getInstance();
        monday.setTime(date);
        monday.setFirstDayOfWeek(2);
        monday.set(7, 2);
        return monday.getTime();
    }

    public static Date getFirstDateOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        c.set(5, c.getActualMinimum(5));
        return c.getTime();
    }

    public static Date getFirstDateOfMonthByDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMinimum(5));
        return c.getTime();
    }

    public static int getSysYear() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        return year;
    }

    public static int getWeekOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(3);
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Date getNextDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static String getFirstDayOfMonth(String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 1);
        return DateUtils.formatDateTime(cal.getTime(), format);
    }

    public static String getLastDayOfMonth(String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return DateUtils.formatDateTime(cal.getTime(), format);
    }

    public static String getFirstDayOfWeek(String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.setFirstDayOfWeek(2);
        cal.set(7, 2);
        return DateUtils.formatDateTime(cal.getTime(), format);
    }

    public static String getLastDayOfWeek(String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.setFirstDayOfWeek(2);
        cal.set(7, 8);
        return DateUtils.formatDateTime(cal.getTime(), format);
    }

    public static String getFirstDayOfYear(String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(6, 1);
        return DateUtils.formatDateTime(cal.getTime(), format);
    }

    public static String getLastDayOfYear(String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(6, 1);
        cal.add(1, 1);
        cal.add(5, -1);
        return DateUtils.formatDateTime(cal.getTime(), format);
    }

    public static String getLastDayOfNextMonth(String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(5, 1);
        cal.add(2, 2);
        cal.add(5, -1);
        return DateUtils.formatDateTime(cal.getTime(), format);
    }

    public static int[] getDateTimeSub(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int y1 = cal.get(1);
        int m1 = cal.get(2);
        int d1 = cal.get(6);
        cal.setTime(date2);
        int y2 = cal.get(1);
        int m2 = cal.get(2);
        int d2 = cal.get(6);
        int[] array = new int[]{y1 - y2, m1 - m2, d1 - d2};
        return array;
    }

    public static int dateDiff(String startTime, String endTime) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        long nd = 86400000L;
        long day = 0L;
        try {
            long diff = sd.parse(endTime).getTime() - sd.parse(startTime).getTime();
            day = diff / nd;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return (int)day;
    }
}

