/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonUtils {
    public static String object2json(Object obj) {
        StringBuilder json = new StringBuilder();
        if (obj == null) {
            json.append("\"\"");
        } else if (obj instanceof String || obj instanceof Integer || obj instanceof Float || obj instanceof Boolean || obj instanceof Short || obj instanceof Double || obj instanceof Long || obj instanceof BigDecimal || obj instanceof BigInteger || obj instanceof Byte) {
            json.append("\"").append(JsonUtils.string2json(obj.toString())).append("\"");
        } else if (obj instanceof Object[]) {
            json.append(JsonUtils.array2json((Object[])obj));
        } else if (obj instanceof List) {
            json.append(JsonUtils.list2json((List)obj));
        } else if (obj instanceof Map) {
            json.append(JsonUtils.map2json((Map)obj));
        } else if (obj instanceof Set) {
            json.append(JsonUtils.set2json((Set)obj));
        } else {
            json.append(JsonUtils.bean2json(obj));
        }
        return json.toString();
    }

    public static String object2json2(Object obj) {
        StringBuilder json = new StringBuilder();
        if (obj == null) {
            json.append("\"\"");
        } else if (obj instanceof String || obj instanceof Integer || obj instanceof Float || obj instanceof Boolean || obj instanceof Short || obj instanceof Double || obj instanceof Long || obj instanceof BigDecimal || obj instanceof BigInteger || obj instanceof Byte) {
            json.append(JsonUtils.string2json(obj.toString()));
        } else if (obj instanceof Object[]) {
            json.append(JsonUtils.array2json((Object[])obj));
        } else if (obj instanceof List) {
            json.append(JsonUtils.list2json((List)obj));
        } else if (obj instanceof Map) {
            json.append(JsonUtils.map2json((Map)obj));
        } else if (obj instanceof Set) {
            json.append(JsonUtils.set2json((Set)obj));
        } else {
            json.append(JsonUtils.bean2json(obj));
        }
        return json.toString();
    }

    public static String bean2json(Object bean) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        PropertyDescriptor[] props = null;
        try {
            props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                try {
                    String name = JsonUtils.object2json(props[i].getName());
                    String value = JsonUtils.object2json(props[i].getReadMethod().invoke(bean, new Object[0]));
                    json.append(name);
                    json.append(":");
                    json.append(value);
                    json.append(",");
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public static String list2json(List<?> list) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (list != null && list.size() > 0) {
            for (Object obj : list) {
                json.append(JsonUtils.object2json(obj));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }

    public static String array2json(Object[] array) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (array != null && array.length > 0) {
            for (Object obj : array) {
                json.append(JsonUtils.object2json(obj));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }

    public static String map2json(Map<?, ?> map) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        if (map != null && map.size() > 0) {
            for (Object key : map.keySet()) {
                json.append(JsonUtils.object2json(key));
                json.append(":");
                json.append(JsonUtils.object2json(map.get(key)));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public static String set2json(Set<?> set) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (set != null && set.size() > 0) {
            for (Object obj : set) {
                json.append(JsonUtils.object2json(obj));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }

    public static String string2json(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

