/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ResourceUtils {
    private String configFile;
    private String encode;

    public ResourceUtils(String configFile, String encode) {
        this.setConfigFile(configFile);
        this.setEncode(encode);
    }

    public String getProperty(String propertyKey) {
        Properties prop = new Properties();
        try {
            FileInputStream is = new FileInputStream(ResourceUtils.class.getResource("/" + this.configFile).getPath());
            prop.load(is);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String propertyValue = prop.getProperty(propertyKey, this.encode);
        System.out.println(propertyValue);
        return propertyValue;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(String configFile) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        try {
            String content;
            is = loader.getResourceAsStream(configFile);
            if (is == null) {
                throw new IOException(String.format("Resource [%1s] is not found.", configFile));
            }
            int i = -1;
            byte[] b = new byte[1024];
            StringBuffer sb = new StringBuffer();
            while ((i = is.read(b)) != -1) {
                sb.append(new String(b, 0, i));
            }
            String string = content = sb.toString();
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

